/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.transforms;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.indexing.IndexerState;
import org.elasticsearch.xpack.core.transform.TransformField;
import org.elasticsearch.xpack.core.transform.transforms.NodeAttributes;
import org.elasticsearch.xpack.core.transform.transforms.TransformCheckpointingInfo;
import org.elasticsearch.xpack.core.transform.transforms.TransformHealth;
import org.elasticsearch.xpack.core.transform.transforms.TransformIndexerStats;
import org.elasticsearch.xpack.core.transform.transforms.TransformTaskState;

public class TransformStats
implements Writeable,
ToXContentObject {
    public static final String NAME = "data_frame_transform_stats";
    public static final ParseField HEALTH_FIELD = new ParseField("health", new String[0]);
    public static final ParseField STATE_FIELD = new ParseField("state", new String[0]);
    public static final ParseField REASON_FIELD = new ParseField("reason", new String[0]);
    public static final ParseField NODE_FIELD = new ParseField("node", new String[0]);
    public static final ParseField CHECKPOINTING_INFO_FIELD = new ParseField("checkpointing", new String[0]);
    private final String id;
    private final State state;
    @Nullable
    private final String reason;
    @Nullable
    private NodeAttributes node;
    private final TransformIndexerStats indexerStats;
    private final TransformCheckpointingInfo checkpointingInfo;
    private final TransformHealth health;

    public static TransformStats initialStats(String id) {
        return new TransformStats(id, State.STOPPED, null, null, new TransformIndexerStats(), TransformCheckpointingInfo.EMPTY, TransformHealth.GREEN);
    }

    public TransformStats(String id, State state, @Nullable String reason, @Nullable NodeAttributes node, TransformIndexerStats stats, TransformCheckpointingInfo checkpointingInfo, TransformHealth health) {
        this.id = Objects.requireNonNull(id);
        this.state = Objects.requireNonNull(state);
        this.reason = reason;
        this.node = node;
        this.indexerStats = Objects.requireNonNull(stats);
        this.checkpointingInfo = Objects.requireNonNull(checkpointingInfo);
        this.health = Objects.requireNonNull(health);
    }

    public TransformStats(StreamInput in) throws IOException {
        this.id = in.readString();
        this.state = (State)in.readEnum(State.class);
        this.reason = in.readOptionalString();
        this.node = in.readBoolean() ? new NodeAttributes(in) : null;
        this.indexerStats = new TransformIndexerStats(in);
        this.checkpointingInfo = new TransformCheckpointingInfo(in);
        this.health = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_6_0) ? (in.readBoolean() ? new TransformHealth(in) : null) : null;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TransformField.ID.getPreferredName(), this.id);
        builder.field(STATE_FIELD.getPreferredName(), this.state.value());
        if (this.reason != null) {
            builder.field(REASON_FIELD.getPreferredName(), this.reason);
        }
        if (this.node != null) {
            builder.field(NODE_FIELD.getPreferredName(), (ToXContent)this.node);
        }
        builder.field(TransformField.STATS_FIELD.getPreferredName(), (ToXContent)this.indexerStats, params);
        builder.field(CHECKPOINTING_INFO_FIELD.getPreferredName(), (ToXContent)this.checkpointingInfo, params);
        if (this.health != null) {
            builder.field(HEALTH_FIELD.getPreferredName(), (ToXContent)this.health);
        }
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeEnum((Enum)this.state);
        out.writeOptionalString(this.reason);
        if (this.node != null) {
            out.writeBoolean(true);
            this.node.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        this.indexerStats.writeTo(out);
        this.checkpointingInfo.writeTo(out);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_6_0)) {
            if (this.health != null) {
                out.writeBoolean(true);
                this.health.writeTo(out);
            } else {
                out.writeBoolean(false);
            }
        }
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.state, this.reason, this.node, this.indexerStats, this.checkpointingInfo, this.health});
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TransformStats that = (TransformStats)other;
        return Objects.equals(this.id, that.id) && Objects.equals((Object)this.state, (Object)that.state) && Objects.equals(this.reason, that.reason) && Objects.equals(this.node, that.node) && Objects.equals(this.indexerStats, that.indexerStats) && Objects.equals(this.checkpointingInfo, that.checkpointingInfo) && Objects.equals(this.health, that.health);
    }

    public String getId() {
        return this.id;
    }

    public State getState() {
        return this.state;
    }

    @Nullable
    public String getReason() {
        return this.reason;
    }

    @Nullable
    public NodeAttributes getNode() {
        return this.node;
    }

    public void setNode(NodeAttributes node) {
        this.node = node;
    }

    public TransformIndexerStats getIndexerStats() {
        return this.indexerStats;
    }

    public TransformCheckpointingInfo getCheckpointingInfo() {
        return this.checkpointingInfo;
    }

    public TransformHealth getHealth() {
        return this.health;
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public static final class State
    extends Enum<State>
    implements Writeable {
        public static final /* enum */ State STARTED = new State();
        public static final /* enum */ State INDEXING = new State();
        public static final /* enum */ State ABORTING = new State();
        public static final /* enum */ State STOPPING = new State();
        public static final /* enum */ State STOPPED = new State();
        public static final /* enum */ State FAILED = new State();
        public static final /* enum */ State WAITING = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String name) {
            return Enum.valueOf(State.class, name);
        }

        public static State fromString(String name) {
            return State.valueOf(name.trim().toUpperCase(Locale.ROOT));
        }

        public static State fromStream(StreamInput in) throws IOException {
            return (State)in.readEnum(State.class);
        }

        public static State fromComponents(TransformTaskState taskState, IndexerState indexerState) {
            if (taskState == null || taskState == TransformTaskState.STOPPED) {
                return STOPPED;
            }
            if (taskState == TransformTaskState.FAILED) {
                return FAILED;
            }
            assert (taskState == TransformTaskState.STARTED);
            assert (indexerState != null);
            return switch (indexerState) {
                default -> throw new MatchException(null, null);
                case IndexerState.STARTED -> STARTED;
                case IndexerState.INDEXING -> INDEXING;
                case IndexerState.STOPPING -> STOPPING;
                case IndexerState.STOPPED -> STOPPING;
                case IndexerState.ABORTING -> ABORTING;
            };
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeEnum((Enum)this);
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public String value() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        private static /* synthetic */ State[] $values() {
            return new State[]{STARTED, INDEXING, ABORTING, STOPPING, STOPPED, FAILED, WAITING};
        }

        static {
            $VALUES = State.$values();
        }
    }
}

