/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.template;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.rollover.RolloverAction;
import org.elasticsearch.action.admin.indices.rollover.RolloverRequest;
import org.elasticsearch.action.admin.indices.rollover.RolloverResponse;
import org.elasticsearch.action.admin.indices.template.put.PutComponentTemplateAction;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.action.admin.indices.template.put.TransportPutComposableIndexTemplateAction;
import org.elasticsearch.action.ingest.PutPipelineRequest;
import org.elasticsearch.action.ingest.PutPipelineTransportAction;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.IndicesAdminClient;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.ComponentTemplate;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataIndexTemplateService;
import org.elasticsearch.cluster.metadata.Template;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.ingest.IngestMetadata;
import org.elasticsearch.ingest.PipelineConfiguration;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.ilm.action.ILMActions;
import org.elasticsearch.xpack.core.ilm.action.PutLifecycleRequest;
import org.elasticsearch.xpack.core.template.IndexTemplateConfig;
import org.elasticsearch.xpack.core.template.IngestPipelineConfig;
import org.elasticsearch.xpack.core.template.LifecyclePolicyConfig;

public abstract class IndexTemplateRegistry
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(IndexTemplateRegistry.class);
    private static final TimeValue REGISTRY_ACTION_TIMEOUT = TimeValue.THIRTY_SECONDS;
    protected final Settings settings;
    protected final Client client;
    protected final ThreadPool threadPool;
    protected final NamedXContentRegistry xContentRegistry;
    protected final ClusterService clusterService;
    protected final ConcurrentMap<String, AtomicBoolean> templateCreationsInProgress = new ConcurrentHashMap<String, AtomicBoolean>();
    protected final ConcurrentMap<String, AtomicBoolean> policyCreationsInProgress = new ConcurrentHashMap<String, AtomicBoolean>();
    protected final ConcurrentMap<String, AtomicBoolean> pipelineCreationsInProgress = new ConcurrentHashMap<String, AtomicBoolean>();
    protected final List<LifecyclePolicy> lifecyclePolicies;

    public IndexTemplateRegistry(Settings nodeSettings, ClusterService clusterService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry) {
        this.settings = nodeSettings;
        this.client = client;
        this.threadPool = threadPool;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
        this.lifecyclePolicies = !DataStreamLifecycle.isDataStreamsLifecycleOnlyMode((Settings)clusterService.getSettings()) ? this.getLifecycleConfigs().stream().map(config -> config.load(LifecyclePolicyConfig.DEFAULT_X_CONTENT_REGISTRY)).toList() : List.of();
    }

    protected List<LifecyclePolicyConfig> getLifecycleConfigs() {
        return List.of();
    }

    public void initialize() {
        this.clusterService.addListener((ClusterStateListener)this);
    }

    protected List<IndexTemplateConfig> getLegacyTemplateConfigs() {
        return Collections.emptyList();
    }

    protected Map<String, ComponentTemplate> getComponentTemplateConfigs() {
        return Map.of();
    }

    protected Map<String, ComposableIndexTemplate> getComposableTemplateConfigs() {
        return Map.of();
    }

    protected List<LifecyclePolicy> getLifecyclePolicies() {
        return this.lifecyclePolicies;
    }

    protected List<IngestPipelineConfig> getIngestPipelines() {
        return Collections.emptyList();
    }

    protected abstract String getOrigin();

    protected void onPutTemplateFailure(String templateName, Exception e) {
        logger.error(() -> Strings.format((String)"error adding index template [%s] for [%s]", (Object[])new Object[]{templateName, this.getOrigin()}), (Throwable)e);
    }

    protected void onPutPolicyFailure(LifecyclePolicy policy, Exception e) {
        logger.error(() -> Strings.format((String)"error adding lifecycle policy [%s] for [%s]", (Object[])new Object[]{policy.getName(), this.getOrigin()}), (Throwable)e);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        ClusterState state = event.state();
        if (state.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        DiscoveryNode masterNode = event.state().getNodes().getMasterNode();
        if (masterNode == null) {
            return;
        }
        if (this.requiresMasterNode() && !state.nodes().isLocalNodeElectedMaster()) {
            return;
        }
        if (!this.isClusterReady(event)) {
            return;
        }
        DiscoveryNode localNode = event.state().getNodes().getLocalNode();
        boolean localNodeVersionAfterMaster = localNode.getVersion().after((VersionId)masterNode.getVersion());
        if (event.localNodeMaster() || localNodeVersionAfterMaster) {
            this.addIngestPipelinesIfMissing(state);
            this.addTemplatesIfMissing(state);
            this.addIndexLifecyclePoliciesIfMissing(state);
        }
    }

    protected boolean isClusterReady(ClusterChangedEvent event) {
        return true;
    }

    protected boolean requiresMasterNode() {
        return false;
    }

    private void addTemplatesIfMissing(ClusterState state) {
        this.addLegacyTemplatesIfMissing(state);
        this.addComponentTemplatesIfMissing(state);
        this.addComposableTemplatesIfMissing(state);
    }

    private void addLegacyTemplatesIfMissing(ClusterState state) {
        if (DataStreamLifecycle.isDataStreamsLifecycleOnlyMode((Settings)this.clusterService.getSettings())) {
            return;
        }
        List<IndexTemplateConfig> indexTemplates = this.getLegacyTemplateConfigs();
        for (IndexTemplateConfig newTemplate : indexTemplates) {
            String templateName = newTemplate.getTemplateName();
            AtomicBoolean creationCheck = this.templateCreationsInProgress.computeIfAbsent(templateName, key -> new AtomicBoolean(false));
            if (creationCheck.compareAndSet(false, true)) {
                IndexTemplateMetadata currentTemplate = (IndexTemplateMetadata)state.metadata().getTemplates().get(templateName);
                if (Objects.isNull(currentTemplate)) {
                    logger.debug("adding legacy template [{}] for [{}], because it doesn't exist", (Object)templateName, (Object)this.getOrigin());
                    this.putLegacyTemplate(newTemplate, creationCheck);
                    continue;
                }
                if (Objects.isNull(currentTemplate.getVersion()) || newTemplate.getVersion() > currentTemplate.getVersion()) {
                    logger.info("upgrading legacy template [{}] for [{}] from version [{}] to version [{}]", (Object)templateName, (Object)this.getOrigin(), (Object)currentTemplate.getVersion(), (Object)newTemplate.getVersion());
                    this.putLegacyTemplate(newTemplate, creationCheck);
                    continue;
                }
                creationCheck.set(false);
                logger.trace("not adding legacy template [{}] for [{}], because it already exists at version [{}]", (Object)templateName, (Object)this.getOrigin(), (Object)currentTemplate.getVersion());
                continue;
            }
            logger.trace("skipping the creation of legacy template [{}] for [{}], because its creation is in progress", (Object)templateName, (Object)this.getOrigin());
        }
    }

    private void addComponentTemplatesIfMissing(ClusterState state) {
        Map<String, ComponentTemplate> indexTemplates = this.getComponentTemplateConfigs();
        for (Map.Entry<String, ComponentTemplate> newTemplate : indexTemplates.entrySet()) {
            String templateName = newTemplate.getKey();
            AtomicBoolean creationCheck = this.templateCreationsInProgress.computeIfAbsent(templateName, key -> new AtomicBoolean(false));
            if (creationCheck.compareAndSet(false, true)) {
                ComponentTemplate currentTemplate = (ComponentTemplate)state.metadata().componentTemplates().get(templateName);
                if (!IndexTemplateRegistry.templateDependenciesSatisfied(state, newTemplate.getValue())) {
                    creationCheck.set(false);
                    logger.trace("not adding index template [{}] for [{}] because its required dependencies do not exist", (Object)templateName, (Object)this.getOrigin());
                    continue;
                }
                if (Objects.isNull(currentTemplate)) {
                    logger.debug("adding component template [{}] for [{}], because it doesn't exist", (Object)templateName, (Object)this.getOrigin());
                    this.putComponentTemplate(templateName, newTemplate.getValue(), creationCheck);
                    continue;
                }
                if (Objects.isNull(currentTemplate.version()) || newTemplate.getValue().version() > currentTemplate.version()) {
                    logger.info("upgrading component template [{}] for [{}] from version [{}] to version [{}]", (Object)templateName, (Object)this.getOrigin(), (Object)currentTemplate.version(), (Object)newTemplate.getValue().version());
                    this.putComponentTemplate(templateName, newTemplate.getValue(), creationCheck);
                    continue;
                }
                creationCheck.set(false);
                logger.trace("not adding component template [{}] for [{}], because it already exists at version [{}]", (Object)templateName, (Object)this.getOrigin(), (Object)currentTemplate.version());
                continue;
            }
            logger.trace("skipping the creation of component template [{}] for [{}], because its creation is in progress", (Object)templateName, (Object)this.getOrigin());
        }
    }

    private static boolean templateDependenciesSatisfied(ClusterState state, ComponentTemplate indexTemplate) {
        Template template = indexTemplate.template();
        if (template == null) {
            return true;
        }
        Settings settings = template.settings();
        if (settings == null) {
            return true;
        }
        IngestMetadata ingestMetadata = (IngestMetadata)state.metadata().custom("ingest");
        String defaultPipeline = settings.get("index.default_pipeline");
        if (!(defaultPipeline == null || ingestMetadata != null && ingestMetadata.getPipelines().containsKey(defaultPipeline))) {
            return false;
        }
        String finalPipeline = settings.get("index.final_pipeline");
        if (finalPipeline != null) {
            return ingestMetadata != null && ingestMetadata.getPipelines().containsKey(finalPipeline);
        }
        return true;
    }

    private void addComposableTemplatesIfMissing(ClusterState state) {
        Map<String, ComposableIndexTemplate> indexTemplates = this.getComposableTemplateConfigs();
        for (Map.Entry<String, ComposableIndexTemplate> newTemplate : indexTemplates.entrySet()) {
            String templateName = newTemplate.getKey();
            AtomicBoolean creationCheck = this.templateCreationsInProgress.computeIfAbsent(templateName, key -> new AtomicBoolean(false));
            if (creationCheck.compareAndSet(false, true)) {
                ComposableIndexTemplate currentTemplate = (ComposableIndexTemplate)state.metadata().templatesV2().get(templateName);
                boolean componentTemplatesAvailable = this.componentTemplatesInstalled(state, newTemplate.getValue());
                if (!componentTemplatesAvailable) {
                    creationCheck.set(false);
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace("not adding composable template [{}] for [{}] because its required component templates do not exist or do not have the right version", (Object)templateName, (Object)this.getOrigin());
                    continue;
                }
                if (Objects.isNull(currentTemplate)) {
                    logger.debug("adding composable template [{}] for [{}], because it doesn't exist", (Object)templateName, (Object)this.getOrigin());
                    this.putComposableTemplate(state, templateName, newTemplate.getValue(), creationCheck);
                    continue;
                }
                if (Objects.isNull(currentTemplate.version()) || newTemplate.getValue().version() > currentTemplate.version()) {
                    logger.info("upgrading composable template [{}] for [{}] from version [{}] to version [{}]", (Object)templateName, (Object)this.getOrigin(), (Object)currentTemplate.version(), (Object)newTemplate.getValue().version());
                    this.putComposableTemplate(state, templateName, newTemplate.getValue(), creationCheck);
                    continue;
                }
                creationCheck.set(false);
                logger.trace("not adding composable template [{}] for [{}], because it already exists at version [{}]", (Object)templateName, (Object)this.getOrigin(), (Object)currentTemplate.version());
                continue;
            }
            logger.trace("skipping the creation of composable template [{}] for [{}], because its creation is in progress", (Object)templateName, (Object)this.getOrigin());
        }
    }

    private boolean componentTemplatesInstalled(ClusterState state, ComposableIndexTemplate indexTemplate) {
        if (!this.applyRolloverAfterTemplateV2Update()) {
            return state.metadata().componentTemplates().keySet().containsAll(indexTemplate.getRequiredComponentTemplates());
        }
        Map<String, ComponentTemplate> componentTemplateConfigs = this.getComponentTemplateConfigs();
        Map installedTemplates = state.metadata().componentTemplates();
        for (String templateName : indexTemplate.getRequiredComponentTemplates()) {
            ComponentTemplate installedTemplate = (ComponentTemplate)installedTemplates.get(templateName);
            if (installedTemplate == null) {
                return false;
            }
            ComponentTemplate templateConfig = componentTemplateConfigs.get(templateName);
            if (templateConfig == null || templateConfig.version().equals(installedTemplate.version())) continue;
            return false;
        }
        return true;
    }

    private void putLegacyTemplate(IndexTemplateConfig config, final AtomicBoolean creationCheck) {
        ExecutorService executor = this.threadPool.generic();
        executor.execute(() -> {
            final String templateName = config.getTemplateName();
            PutIndexTemplateRequest request = new PutIndexTemplateRequest(templateName).source(config.loadBytes(), XContentType.JSON);
            request.masterNodeTimeout(TimeValue.MAX_VALUE);
            ClientHelper.executeAsyncWithOrigin(this.client.threadPool().getThreadContext(), this.getOrigin(), request, new ActionListener<AcknowledgedResponse>(){

                public void onResponse(AcknowledgedResponse response) {
                    creationCheck.set(false);
                    if (!response.isAcknowledged()) {
                        logger.error("error adding legacy template [{}] for [{}], request was not acknowledged", (Object)templateName, (Object)IndexTemplateRegistry.this.getOrigin());
                    }
                }

                public void onFailure(Exception e) {
                    creationCheck.set(false);
                    IndexTemplateRegistry.this.onPutTemplateFailure(templateName, e);
                }
            }, (arg_0, arg_1) -> ((IndicesAdminClient)this.client.admin().indices()).putTemplate(arg_0, arg_1));
        });
    }

    private void putComponentTemplate(final String templateName, ComponentTemplate template, final AtomicBoolean creationCheck) {
        ExecutorService executor = this.threadPool.generic();
        executor.execute(() -> {
            PutComponentTemplateAction.Request request = new PutComponentTemplateAction.Request(templateName).componentTemplate(template);
            request.masterNodeTimeout(TimeValue.MAX_VALUE);
            ClientHelper.executeAsyncWithOrigin(this.client.threadPool().getThreadContext(), this.getOrigin(), request, new ActionListener<AcknowledgedResponse>(){

                public void onResponse(AcknowledgedResponse response) {
                    creationCheck.set(false);
                    if (!response.isAcknowledged()) {
                        logger.error("error adding component template [{}] for [{}], request was not acknowledged", (Object)templateName, (Object)IndexTemplateRegistry.this.getOrigin());
                    }
                }

                public void onFailure(Exception e) {
                    creationCheck.set(false);
                    IndexTemplateRegistry.this.onPutTemplateFailure(templateName, e);
                }
            }, (req, listener) -> this.client.execute((ActionType)PutComponentTemplateAction.INSTANCE, (ActionRequest)req, listener));
        });
    }

    private void putComposableTemplate(final ClusterState state, final String templateName, final ComposableIndexTemplate indexTemplate, final AtomicBoolean creationCheck) {
        ExecutorService executor = this.threadPool.generic();
        executor.execute(() -> {
            TransportPutComposableIndexTemplateAction.Request request = new TransportPutComposableIndexTemplateAction.Request(templateName).indexTemplate(indexTemplate);
            request.masterNodeTimeout(TimeValue.MAX_VALUE);
            ClientHelper.executeAsyncWithOrigin(this.client.threadPool().getThreadContext(), this.getOrigin(), request, new ActionListener<AcknowledgedResponse>(){

                public void onResponse(AcknowledgedResponse response) {
                    if (response.isAcknowledged()) {
                        if (IndexTemplateRegistry.this.applyRolloverAfterTemplateV2Update()) {
                            IndexTemplateRegistry.this.invokeRollover(state, templateName, indexTemplate, () -> creationCheck.set(false));
                        } else {
                            creationCheck.set(false);
                        }
                    } else {
                        creationCheck.set(false);
                        logger.error("error adding composable template [{}] for [{}], request was not acknowledged", (Object)templateName, (Object)IndexTemplateRegistry.this.getOrigin());
                    }
                }

                public void onFailure(Exception e) {
                    creationCheck.set(false);
                    IndexTemplateRegistry.this.onPutTemplateFailure(templateName, e);
                }
            }, (req, listener) -> this.client.execute(TransportPutComposableIndexTemplateAction.TYPE, (ActionRequest)req, listener));
        });
    }

    private void addIndexLifecyclePoliciesIfMissing(ClusterState state) {
        if (DataStreamLifecycle.isDataStreamsLifecycleOnlyMode((Settings)this.clusterService.getSettings())) {
            logger.trace("running in data stream lifecycle only mode. skipping the installation of ILM policies.");
            return;
        }
        IndexLifecycleMetadata metadata = (IndexLifecycleMetadata)state.metadata().custom("index_lifecycle");
        Map<Object, Object> policies = metadata != null ? metadata.getPolicies() : Map.of();
        for (LifecyclePolicy policy : this.getLifecyclePolicies()) {
            AtomicBoolean creationCheck = this.policyCreationsInProgress.computeIfAbsent(policy.getName(), key -> new AtomicBoolean(false));
            if (!creationCheck.compareAndSet(false, true)) continue;
            LifecyclePolicy currentPolicy = (LifecyclePolicy)policies.get(policy.getName());
            if (Objects.isNull(currentPolicy)) {
                logger.debug("adding lifecycle policy [{}] for [{}], because it doesn't exist", (Object)policy.getName(), (Object)this.getOrigin());
                this.putPolicy(policy, creationCheck);
                continue;
            }
            if (this.isUpgradeRequired(currentPolicy, policy)) {
                logger.info("upgrading lifecycle policy [{}] for [{}]", (Object)policy.getName(), (Object)this.getOrigin());
                this.putPolicy(policy, creationCheck);
                continue;
            }
            logger.trace("not adding lifecycle policy [{}] for [{}], because it already exists", (Object)policy.getName(), (Object)this.getOrigin());
            creationCheck.set(false);
        }
    }

    protected boolean isUpgradeRequired(LifecyclePolicy currentPolicy, LifecyclePolicy newPolicy) {
        return false;
    }

    private void putPolicy(final LifecyclePolicy policy, final AtomicBoolean creationCheck) {
        ExecutorService executor = this.threadPool.generic();
        executor.execute(() -> {
            PutLifecycleRequest request = new PutLifecycleRequest(REGISTRY_ACTION_TIMEOUT, REGISTRY_ACTION_TIMEOUT, policy);
            request.masterNodeTimeout(TimeValue.MAX_VALUE);
            ClientHelper.executeAsyncWithOrigin(this.client.threadPool().getThreadContext(), this.getOrigin(), request, new ActionListener<AcknowledgedResponse>(){

                public void onResponse(AcknowledgedResponse response) {
                    creationCheck.set(false);
                    if (!response.isAcknowledged()) {
                        logger.error("error adding lifecycle policy [{}] for [{}], request was not acknowledged", (Object)policy.getName(), (Object)IndexTemplateRegistry.this.getOrigin());
                    }
                }

                public void onFailure(Exception e) {
                    creationCheck.set(false);
                    IndexTemplateRegistry.this.onPutPolicyFailure(policy, e);
                }
            }, (req, listener) -> this.client.execute(ILMActions.PUT, (ActionRequest)req, listener));
        });
    }

    protected static Map<String, ComposableIndexTemplate> parseComposableTemplates(IndexTemplateConfig ... config) {
        return Arrays.stream(config).collect(Collectors.toUnmodifiableMap(IndexTemplateConfig::getTemplateName, indexTemplateConfig -> {
            ComposableIndexTemplate composableIndexTemplate;
            block8: {
                XContentParser parser = JsonXContent.jsonXContent.createParser(XContentParserConfiguration.EMPTY, indexTemplateConfig.loadBytes());
                try {
                    composableIndexTemplate = ComposableIndexTemplate.parse((XContentParser)parser);
                    if (parser == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new AssertionError((Object)e);
                    }
                }
                parser.close();
            }
            return composableIndexTemplate;
        }));
    }

    private void addIngestPipelinesIfMissing(ClusterState state) {
        for (IngestPipelineConfig requiredPipeline : this.getIngestPipelines()) {
            AtomicBoolean creationCheck = this.pipelineCreationsInProgress.computeIfAbsent(requiredPipeline.getId(), key -> new AtomicBoolean(false));
            if (!creationCheck.compareAndSet(false, true)) continue;
            List<String> pipelineDependencies = requiredPipeline.getPipelineDependencies();
            if (pipelineDependencies != null && !IndexTemplateRegistry.pipelineDependenciesExist(state, pipelineDependencies)) {
                creationCheck.set(false);
                logger.trace("not adding ingest pipeline [{}] for [{}] because its dependencies do not exist", (Object)requiredPipeline.getId(), (Object)this.getOrigin());
                continue;
            }
            PipelineConfiguration existingPipeline = IndexTemplateRegistry.findInstalledPipeline(state, requiredPipeline.getId());
            if (existingPipeline != null) {
                Integer existingPipelineVersion = existingPipeline.getVersion();
                if (existingPipelineVersion == null || existingPipelineVersion < requiredPipeline.getVersion()) {
                    logger.info("upgrading ingest pipeline [{}] for [{}] from version [{}] to version [{}]", (Object)requiredPipeline.getId(), (Object)this.getOrigin(), (Object)existingPipelineVersion, (Object)requiredPipeline.getVersion());
                    this.putIngestPipeline(requiredPipeline, creationCheck);
                    continue;
                }
                creationCheck.set(false);
                logger.debug("not adding ingest pipeline [{}] for [{}], because it already exists", (Object)requiredPipeline.getId(), (Object)this.getOrigin());
                continue;
            }
            logger.debug("adding ingest pipeline [{}] for [{}], because it doesn't exist", (Object)requiredPipeline.getId(), (Object)this.getOrigin());
            this.putIngestPipeline(requiredPipeline, creationCheck);
        }
    }

    private static boolean pipelineDependenciesExist(ClusterState state, List<String> dependencies) {
        for (String dependency : dependencies) {
            if (IndexTemplateRegistry.findInstalledPipeline(state, dependency) != null) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static PipelineConfiguration findInstalledPipeline(ClusterState state, String pipelineId) {
        Optional<IngestMetadata> maybeMeta = Optional.ofNullable((IngestMetadata)state.metadata().custom("ingest"));
        return maybeMeta.map(ingestMetadata -> (PipelineConfiguration)ingestMetadata.getPipelines().get(pipelineId)).orElse(null);
    }

    private void putIngestPipeline(final IngestPipelineConfig pipelineConfig, final AtomicBoolean creationCheck) {
        ExecutorService executor = this.threadPool.generic();
        executor.execute(() -> {
            PutPipelineRequest request = new PutPipelineRequest(MasterNodeRequest.INFINITE_MASTER_NODE_TIMEOUT, MasterNodeRequest.INFINITE_MASTER_NODE_TIMEOUT, pipelineConfig.getId(), pipelineConfig.loadConfig(), pipelineConfig.getXContentType());
            ClientHelper.executeAsyncWithOrigin(this.client.threadPool().getThreadContext(), this.getOrigin(), request, new ActionListener<AcknowledgedResponse>(){

                public void onResponse(AcknowledgedResponse response) {
                    creationCheck.set(false);
                    if (!response.isAcknowledged()) {
                        logger.error("error adding ingest pipeline [{}] for [{}], request was not acknowledged", (Object)pipelineConfig.getId(), (Object)IndexTemplateRegistry.this.getOrigin());
                    } else {
                        logger.info("adding ingest pipeline {}", (Object)pipelineConfig.getId());
                    }
                }

                public void onFailure(Exception e) {
                    creationCheck.set(false);
                    IndexTemplateRegistry.this.onPutPipelineFailure(pipelineConfig.getId(), e);
                }
            }, (req, listener) -> this.client.execute(PutPipelineTransportAction.TYPE, (ActionRequest)req, listener));
        });
    }

    protected boolean applyRolloverAfterTemplateV2Update() {
        return false;
    }

    protected void onPutPipelineFailure(String pipelineId, Exception e) {
        logger.error(() -> Strings.format((String)"error adding ingest pipeline template [%s] for [%s]", (Object[])new Object[]{pipelineId, this.getOrigin()}), (Throwable)e);
    }

    private void invokeRollover(ClusterState state, String templateName, ComposableIndexTemplate indexTemplate, final Runnable runAfter) {
        ExecutorService executor = this.threadPool.generic();
        executor.execute(() -> {
            List<String> rolloverTargets = IndexTemplateRegistry.findRolloverTargetDataStreams(state, templateName, indexTemplate);
            if (rolloverTargets.isEmpty()) {
                runAfter.run();
                return;
            }
            GroupedActionListener groupedActionListener = new GroupedActionListener(rolloverTargets.size(), (ActionListener)new ActionListener<Collection<RolloverResponse>>(){

                public void onResponse(Collection<RolloverResponse> rolloverResponses) {
                    runAfter.run();
                    IndexTemplateRegistry.this.onRolloversBulkResponse(rolloverResponses);
                }

                public void onFailure(Exception e) {
                    runAfter.run();
                    IndexTemplateRegistry.this.onRolloverFailure(e);
                }
            });
            for (String rolloverTarget : rolloverTargets) {
                logger.info("rolling over data stream [{}] lazily as a followup to the upgrade of the [{}] index template [{}]", (Object)rolloverTarget, (Object)this.getOrigin(), (Object)templateName);
                RolloverRequest request = new RolloverRequest(rolloverTarget, null);
                request.lazy(true);
                request.masterNodeTimeout(TimeValue.MAX_VALUE);
                ClientHelper.executeAsyncWithOrigin(this.client.threadPool().getThreadContext(), this.getOrigin(), request, groupedActionListener, (req, listener) -> this.client.execute((ActionType)RolloverAction.INSTANCE, (ActionRequest)req, listener));
            }
        });
    }

    void onRolloversBulkResponse(Collection<RolloverResponse> rolloverResponses) {
        for (RolloverResponse rolloverResponse : rolloverResponses) {
            assert (rolloverResponse.isLazy() && !rolloverResponse.isRolledOver()) : org.elasticsearch.common.Strings.format((String)"Expected rollover of the [%s] index [%s] to be lazy", (Object[])new Object[]{this.getOrigin(), rolloverResponse.getOldIndex()});
        }
    }

    void onRolloverFailure(Exception e) {
        logger.error(String.format(Locale.ROOT, "[%s] related rollover failed", this.getOrigin()), (Throwable)e);
        for (Throwable throwable : e.getSuppressed()) {
            logger.error(String.format(Locale.ROOT, "[%s] related rollover failed", this.getOrigin()), throwable);
        }
    }

    static List<String> findRolloverTargetDataStreams(ClusterState state, String templateName, ComposableIndexTemplate indexTemplate) {
        Metadata metadata = state.metadata();
        return metadata.dataStreams().values().stream().filter(ds -> indexTemplate.indexPatterns().stream().anyMatch(pattern -> Regex.simpleMatch((String)pattern, (String)ds.getName()))).filter(ds -> {
            String dsTemplateName = MetadataIndexTemplateService.findV2Template((Metadata)metadata, (String)ds.getName(), (boolean)ds.isHidden());
            if (templateName.equals(dsTemplateName)) {
                return true;
            }
            ComposableIndexTemplate dsTemplate = (ComposableIndexTemplate)metadata.templatesV2().get(dsTemplateName);
            return dsTemplate == null || indexTemplate.priorityOrZero() > dsTemplate.priorityOrZero();
        }).map(DataStream::getName).collect(Collectors.toList());
    }
}

