/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.restriction;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public record Workflow(String name, Set<String> allowedRestHandlers) {
    public Workflow(String name, Set<String> allowedRestHandlers) {
        assert (!allowedRestHandlers.isEmpty()) : "allowed rest handlers must not be empty";
        this.name = Objects.requireNonNull(name, "workflow name must be provided");
        this.allowedRestHandlers = Set.copyOf(allowedRestHandlers);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private final Set<String> allowedRestHandlers = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder addAllowedRestHandler(String handler) {
            this.allowedRestHandlers.add(handler);
            return this;
        }

        public Builder addAllowedRestHandlers(String ... handlers) {
            for (String handler : handlers) {
                this.addAllowedRestHandler(handler);
            }
            return this;
        }

        public Workflow build() {
            return new Workflow(this.name, this.allowedRestHandlers);
        }
    }
}

