/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.user;

import java.io.IOException;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.core.security.action.user.UserRequest;

public class GetUsersRequest
extends ActionRequest
implements UserRequest {
    private String[] usernames;
    private boolean withProfileUid;

    public GetUsersRequest(StreamInput in) throws IOException {
        super(in);
        this.usernames = in.readStringArray();
        this.withProfileUid = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_5_0) ? in.readBoolean() : false;
    }

    public GetUsersRequest() {
        this.usernames = Strings.EMPTY_ARRAY;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.usernames == null) {
            validationException = ValidateActions.addValidationError((String)"usernames cannot be null", validationException);
        }
        return validationException;
    }

    public void usernames(String ... usernames) {
        this.usernames = usernames;
    }

    @Override
    public String[] usernames() {
        return this.usernames;
    }

    public String[] getUsernames() {
        return this.usernames;
    }

    public void setUsernames(String[] usernames) {
        this.usernames = usernames;
    }

    public boolean isWithProfileUid() {
        return this.withProfileUid;
    }

    public void setWithProfileUid(boolean withProfileUid) {
        this.withProfileUid = withProfileUid;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.usernames);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_5_0)) {
            out.writeBoolean(this.withProfileUid);
        }
    }
}

