/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.rest.action;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.protocol.xpack.XPackUsageRequest;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.XPackFeatureUsage;
import org.elasticsearch.xpack.core.action.XPackUsageAction;
import org.elasticsearch.xpack.core.action.XPackUsageResponse;

@ServerlessScope(value=Scope.INTERNAL)
public class RestXPackUsageAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_xpack/usage"));
    }

    public String getName() {
        return "xpack_usage_action";
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        XPackUsageRequest usageRequest = new XPackUsageRequest(RestUtils.getMasterNodeTimeout((RestRequest)request));
        return channel -> new RestCancellableNodeClient(client, request.getHttpChannel()).execute(XPackUsageAction.INSTANCE, (ActionRequest)usageRequest, (ActionListener)new RestBuilderListener<XPackUsageResponse>(this, channel){

            public RestResponse buildResponse(XPackUsageResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                for (XPackFeatureUsage usage : response.getUsages()) {
                    builder.field(usage.name(), (ToXContent)usage);
                }
                builder.endObject();
                return new RestResponse(RestStatus.OK, builder);
            }
        });
    }

    public Set<String> supportedCapabilities() {
        return Sets.union((Set)super.supportedCapabilities(), Set.of("global_retention_telemetry"));
    }
}

