/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.MlConfigVersion;
import org.elasticsearch.xpack.core.ml.inference.persistence.InferenceIndexConstants;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.NlpConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TargetType;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TextSimilarityConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.Tokenization;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TokenizationConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.VocabularyConfig;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.NamedXContentObjectHelper;

public class TextSimilarityConfig
implements NlpConfig {
    public static final String NAME = "text_similarity";
    public static final ParseField TEXT = new ParseField("text", new String[0]);
    public static final ParseField SPAN_SCORE_COMBINATION_FUNCTION = new ParseField("span_score_combination_function", new String[0]);
    private static final ConstructingObjectParser<TextSimilarityConfig, Void> STRICT_PARSER = TextSimilarityConfig.createParser(false);
    private static final ConstructingObjectParser<TextSimilarityConfig, Void> LENIENT_PARSER = TextSimilarityConfig.createParser(true);
    private final VocabularyConfig vocabularyConfig;
    private final Tokenization tokenization;
    private final String resultsField;
    private final String text;
    private final SpanScoreFunction spanScoreFunction;

    public static TextSimilarityConfig fromXContentStrict(XContentParser parser) {
        return (TextSimilarityConfig)STRICT_PARSER.apply(parser, null);
    }

    public static TextSimilarityConfig fromXContentLenient(XContentParser parser) {
        return (TextSimilarityConfig)LENIENT_PARSER.apply(parser, null);
    }

    private static ConstructingObjectParser<TextSimilarityConfig, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser parser = new ConstructingObjectParser(NAME, ignoreUnknownFields, a -> new TextSimilarityConfig((VocabularyConfig)a[0], (Tokenization)a[1], (String)a[2], (String)a[3]));
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
            if (!ignoreUnknownFields) {
                throw ExceptionsHelper.badRequestException("illegal setting [{}] on inference model creation", VOCABULARY.getPreferredName());
            }
            return VocabularyConfig.fromXContentLenient(p);
        }, VOCABULARY);
        parser.declareNamedObject(ConstructingObjectParser.optionalConstructorArg(), (p, c, n) -> (Tokenization)p.namedObject(Tokenization.class, n, (Object)ignoreUnknownFields), TOKENIZATION);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), RESULTS_FIELD);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), SPAN_SCORE_COMBINATION_FUNCTION);
        return parser;
    }

    TextSimilarityConfig(@Nullable VocabularyConfig vocabularyConfig, @Nullable Tokenization tokenization, @Nullable String resultsField, @Nullable String spanScoreFunction) {
        this.vocabularyConfig = Optional.ofNullable(vocabularyConfig).orElse(new VocabularyConfig(InferenceIndexConstants.nativeDefinitionStore()));
        this.tokenization = tokenization == null ? Tokenization.createDefault() : tokenization;
        this.resultsField = resultsField;
        this.text = null;
        this.spanScoreFunction = Optional.ofNullable(spanScoreFunction).map(SpanScoreFunction::fromString).orElse(SpanScoreFunction.MAX);
    }

    public TextSimilarityConfig(String text, VocabularyConfig vocabularyConfig, Tokenization tokenization, String resultsField, SpanScoreFunction spanScoreFunction) {
        this.text = ExceptionsHelper.requireNonNull(text, TEXT);
        this.vocabularyConfig = ExceptionsHelper.requireNonNull(vocabularyConfig, VOCABULARY);
        this.tokenization = ExceptionsHelper.requireNonNull(tokenization, TOKENIZATION);
        this.resultsField = resultsField;
        this.spanScoreFunction = spanScoreFunction;
    }

    public TextSimilarityConfig(StreamInput in) throws IOException {
        this.vocabularyConfig = new VocabularyConfig(in);
        this.tokenization = (Tokenization)in.readNamedWriteable(Tokenization.class);
        this.resultsField = in.readOptionalString();
        this.text = in.readOptionalString();
        this.spanScoreFunction = (SpanScoreFunction)in.readEnum(SpanScoreFunction.class);
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.vocabularyConfig.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.tokenization);
        out.writeOptionalString(this.resultsField);
        out.writeOptionalString(this.text);
        out.writeEnum((Enum)this.spanScoreFunction);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(VOCABULARY.getPreferredName(), (ToXContent)this.vocabularyConfig, params);
        NamedXContentObjectHelper.writeNamedObject(builder, params, TOKENIZATION.getPreferredName(), this.tokenization);
        if (this.resultsField != null) {
            builder.field(RESULTS_FIELD.getPreferredName(), this.resultsField);
        }
        if (this.text != null) {
            builder.field(TEXT.getPreferredName(), this.text);
        }
        builder.field(SPAN_SCORE_COMBINATION_FUNCTION.getPreferredName(), this.spanScoreFunction.toString());
        builder.endObject();
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public boolean isTargetTypeSupported(TargetType targetType) {
        return false;
    }

    @Override
    public InferenceConfig apply(InferenceConfigUpdate update) {
        if (update instanceof TextSimilarityConfigUpdate) {
            TextSimilarityConfigUpdate configUpdate = (TextSimilarityConfigUpdate)update;
            return new TextSimilarityConfig(configUpdate.getText(), this.vocabularyConfig, configUpdate.tokenizationUpdate == null ? this.tokenization : configUpdate.tokenizationUpdate.apply(this.tokenization), Optional.ofNullable(configUpdate.getResultsField()).orElse(this.resultsField), Optional.ofNullable(configUpdate.getSpanScoreFunction()).orElse(this.spanScoreFunction));
        }
        if (update instanceof TokenizationConfigUpdate) {
            TokenizationConfigUpdate tokenizationUpdate = (TokenizationConfigUpdate)update;
            Tokenization updatedTokenization = this.getTokenization().updateWindowSettings(tokenizationUpdate.getSpanSettings());
            return new TextSimilarityConfig(this.text, this.vocabularyConfig, updatedTokenization, this.resultsField, this.spanScoreFunction);
        }
        throw this.incompatibleUpdateException(update.getName());
    }

    @Override
    public MlConfigVersion getMinimalSupportedMlConfigVersion() {
        return MlConfigVersion.V_8_5_0;
    }

    @Override
    public TransportVersion getMinimalSupportedTransportVersion() {
        return TransportVersions.V_8_5_0;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextSimilarityConfig that = (TextSimilarityConfig)o;
        return Objects.equals(this.vocabularyConfig, that.vocabularyConfig) && Objects.equals(this.tokenization, that.tokenization) && Objects.equals(this.text, that.text) && Objects.equals((Object)this.spanScoreFunction, (Object)that.spanScoreFunction) && Objects.equals(this.resultsField, that.resultsField);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.vocabularyConfig, this.tokenization, this.resultsField, this.text, this.spanScoreFunction});
    }

    @Override
    public VocabularyConfig getVocabularyConfig() {
        return this.vocabularyConfig;
    }

    @Override
    public Tokenization getTokenization() {
        return this.tokenization;
    }

    public String getText() {
        return this.text;
    }

    public SpanScoreFunction getSpanScoreFunction() {
        return this.spanScoreFunction;
    }

    @Override
    public String getResultsField() {
        return this.resultsField;
    }

    @Override
    public boolean isAllocateOnly() {
        return true;
    }

    public static enum SpanScoreFunction {
        MAX,
        MEAN;


        public static SpanScoreFunction fromString(String value) {
            return SpanScoreFunction.valueOf(value.toUpperCase(Locale.ROOT));
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

