/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.common.socket;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.core.CheckedRunnable;

public final class SocketAccess {
    private SocketAccess() {
    }

    public static <R> R doPrivileged(CheckedSupplier<R, IOException> supplier) throws IOException {
        SpecialPermission.check();
        try {
            return (R)AccessController.doPrivileged(() -> supplier.get());
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    public static void doPrivileged(CheckedRunnable<IOException> action) throws IOException {
        SpecialPermission.check();
        try {
            AccessController.doPrivileged(() -> {
                action.run();
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }
}

