/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.siv;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.cryptomator.siv.SivMode;
import org.cryptomator.siv.ThreadLocals;

final class JceAesCtrComputer
implements SivMode.CtrComputer {
    private final ThreadLocal<Cipher> threadLocalCipher = ThreadLocals.withInitial(() -> {
        try {
            if (jceSecurityProvider == null) {
                return Cipher.getInstance("AES/CTR/NoPadding");
            }
            return Cipher.getInstance("AES/CTR/NoPadding", jceSecurityProvider);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IllegalStateException("AES/CTR/NoPadding not available on this platform.", e);
        }
    });

    public JceAesCtrComputer(Provider jceSecurityProvider) {
    }

    @Override
    public byte[] computeCtr(byte[] input, byte[] key, byte[] iv) {
        try {
            Cipher cipher = this.threadLocalCipher.get();
            cipher.init(1, (Key)new SecretKeySpec(key, "AES"), new IvParameterSpec(iv));
            return cipher.doFinal(input);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
            throw new IllegalArgumentException("Key or IV invalid.");
        }
        catch (BadPaddingException e) {
            throw new IllegalStateException("Cipher doesn't require padding.", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new IllegalStateException("Block size irrelevant for stream ciphers.", e);
        }
    }
}

