/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.migrate.ldapjdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.migrate.ldapjdk.LDAPResponse;
import com.unboundid.util.Extensible;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@Extensible
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public class LDAPExtendedResponse
extends LDAPResponse {
    private static final long serialVersionUID = 7956345950545720834L;
    @NotNull
    private final ExtendedResult extendedResult;

    public LDAPExtendedResponse(@NotNull ExtendedResult extendedResult) {
        super(extendedResult);
        this.extendedResult = extendedResult;
    }

    @Nullable
    public String getID() {
        return this.extendedResult.getOID();
    }

    @Nullable
    public byte[] getValue() {
        ASN1OctetString value = this.extendedResult.getValue();
        if (value == null) {
            return null;
        }
        return value.getValue();
    }

    @NotNull
    public final ExtendedResult toExtendedResult() {
        return this.extendedResult;
    }

    @Override
    @NotNull
    public String toString() {
        return this.extendedResult.toString();
    }
}

