/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.reindex;

import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ParentTaskAssigningClient;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.BulkByScrollTask;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.reindex.AsyncDeleteByQueryAction;
import org.elasticsearch.reindex.BulkByScrollParallelizationHelper;
import org.elasticsearch.reindex.DeleteByQueryMetrics;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDeleteByQueryAction
extends HandledTransportAction<DeleteByQueryRequest, BulkByScrollResponse> {
    private final ThreadPool threadPool;
    private final Client client;
    private final ScriptService scriptService;
    private final ClusterService clusterService;
    private final DeleteByQueryMetrics deleteByQueryMetrics;

    @Inject
    public TransportDeleteByQueryAction(ThreadPool threadPool, ActionFilters actionFilters, Client client, TransportService transportService, ScriptService scriptService, ClusterService clusterService, @Nullable DeleteByQueryMetrics deleteByQueryMetrics) {
        super("indices:data/write/delete/byquery", transportService, actionFilters, DeleteByQueryRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.threadPool = threadPool;
        this.client = client;
        this.scriptService = scriptService;
        this.clusterService = clusterService;
        this.deleteByQueryMetrics = deleteByQueryMetrics;
    }

    public void doExecute(Task task, DeleteByQueryRequest request, ActionListener<BulkByScrollResponse> listener) {
        BulkByScrollTask bulkByScrollTask = (BulkByScrollTask)task;
        long startTime = System.nanoTime();
        BulkByScrollParallelizationHelper.startSlicedAction(request, bulkByScrollTask, (ActionType<BulkByScrollResponse>)DeleteByQueryAction.INSTANCE, listener, this.client, this.clusterService.localNode(), () -> {
            ParentTaskAssigningClient assigningClient = new ParentTaskAssigningClient(this.client, this.clusterService.localNode(), (Task)bulkByScrollTask);
            new AsyncDeleteByQueryAction(bulkByScrollTask, this.logger, assigningClient, this.threadPool, request, this.scriptService, (ActionListener<BulkByScrollResponse>)ActionListener.runAfter((ActionListener)listener, () -> {
                long elapsedTime = TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - startTime);
                if (this.deleteByQueryMetrics != null) {
                    this.deleteByQueryMetrics.recordTookTime(elapsedTime);
                }
            })).start();
        });
    }
}

