/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.runtime;

import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.LatLonGeometry;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.script.GeoPointFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.runtime.AbstractGeoPointScriptFieldQuery;

public class GeoPointScriptFieldGeoShapeQuery
extends AbstractGeoPointScriptFieldQuery {
    private final SpatialPredicate predicate;
    private final LatLonGeometry[] geometries;
    private final ShapeRelation relation;

    public GeoPointScriptFieldGeoShapeQuery(Script script, GeoPointFieldScript.LeafFactory leafFactory, String fieldName, ShapeRelation relation, LatLonGeometry ... geometries) {
        super(script, leafFactory, fieldName);
        this.geometries = geometries;
        this.relation = relation;
        this.predicate = GeoPointScriptFieldGeoShapeQuery.getPredicate(relation, geometries);
    }

    @Override
    protected boolean matches(double[] lats, double[] lons, int count) {
        return this.predicate.matches(lats, lons, count);
    }

    public final String toString(String field) {
        if (this.fieldName().contentEquals(field)) {
            return ((Object)((Object)this)).getClass().getSimpleName();
        }
        return this.fieldName() + ":" + ((Object)((Object)this)).getClass().getSimpleName();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GeoPointScriptFieldGeoShapeQuery that = (GeoPointScriptFieldGeoShapeQuery)((Object)o);
        return this.relation == that.relation && Arrays.equals(this.geometries, that.geometries);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.relation, Arrays.hashCode(this.geometries));
    }

    private static SpatialPredicate getPredicate(ShapeRelation relation, LatLonGeometry ... geometries) {
        switch (relation) {
            case INTERSECTS: {
                GeoEncodingUtils.Component2DPredicate predicate = GeoEncodingUtils.createComponentPredicate((Component2D)LatLonGeometry.create((LatLonGeometry[])geometries));
                return (lats, lons, count) -> {
                    for (int i = 0; i < count; ++i) {
                        int lon;
                        int lat = GeoEncodingUtils.encodeLatitude((double)lats[i]);
                        if (!predicate.test(lat, lon = GeoEncodingUtils.encodeLongitude((double)lons[i]))) continue;
                        return true;
                    }
                    return false;
                };
            }
            case DISJOINT: {
                GeoEncodingUtils.Component2DPredicate predicate = GeoEncodingUtils.createComponentPredicate((Component2D)LatLonGeometry.create((LatLonGeometry[])geometries));
                return (lats, lons, count) -> {
                    for (int i = 0; i < count; ++i) {
                        int lon;
                        int lat = GeoEncodingUtils.encodeLatitude((double)lats[i]);
                        if (!predicate.test(lat, lon = GeoEncodingUtils.encodeLongitude((double)lons[i]))) continue;
                        return false;
                    }
                    return count > 0;
                };
            }
            case WITHIN: {
                GeoEncodingUtils.Component2DPredicate predicate = GeoEncodingUtils.createComponentPredicate((Component2D)LatLonGeometry.create((LatLonGeometry[])geometries));
                return (lats, lons, count) -> {
                    for (int i = 0; i < count; ++i) {
                        int lon;
                        int lat = GeoEncodingUtils.encodeLatitude((double)lats[i]);
                        if (predicate.test(lat, lon = GeoEncodingUtils.encodeLongitude((double)lons[i]))) continue;
                        return false;
                    }
                    return count > 0;
                };
            }
            case CONTAINS: {
                Component2D[] component2DS = new Component2D[geometries.length];
                for (int i = 0; i < geometries.length; ++i) {
                    component2DS[i] = LatLonGeometry.create((LatLonGeometry[])new LatLonGeometry[]{geometries[i]});
                }
                return (lats, lons, count) -> {
                    Component2D.WithinRelation answer = Component2D.WithinRelation.DISJOINT;
                    for (int i = 0; i < count; ++i) {
                        int lat = GeoEncodingUtils.encodeLatitude((double)lats[i]);
                        int lon = GeoEncodingUtils.encodeLongitude((double)lons[i]);
                        for (Component2D component2D : component2DS) {
                            Component2D.WithinRelation withinRelation = component2D.withinPoint((double)lon, (double)lat);
                            if (withinRelation == Component2D.WithinRelation.NOTWITHIN) {
                                return false;
                            }
                            if (withinRelation == Component2D.WithinRelation.DISJOINT) continue;
                            answer = withinRelation;
                        }
                    }
                    return answer == Component2D.WithinRelation.CANDIDATE;
                };
            }
        }
        throw new IllegalArgumentException("Unknown spatial relationship [" + relation.getRelationName() + "]");
    }

    @FunctionalInterface
    private static interface SpatialPredicate {
        public boolean matches(double[] var1, double[] var2, int var3);
    }
}

