/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.ObjectArrayPriorityQueue;
import org.elasticsearch.common.util.ObjectObjectPagedHashMap;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationErrors;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.AggregatorReducer;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.BucketReducer;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.terms.SignificantTerms;
import org.elasticsearch.search.aggregations.bucket.terms.heuristic.SignificanceHeuristic;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class InternalSignificantTerms<A extends InternalSignificantTerms<A, B>, B extends Bucket<B>>
extends InternalMultiBucketAggregation<A, B>
implements SignificantTerms {
    public static final String SCORE = "score";
    public static final String BG_COUNT = "bg_count";
    protected final int requiredSize;
    protected final long minDocCount;

    protected InternalSignificantTerms(String name, int requiredSize, long minDocCount, Map<String, Object> metadata) {
        super(name, metadata);
        this.requiredSize = requiredSize;
        this.minDocCount = minDocCount;
    }

    protected InternalSignificantTerms(StreamInput in) throws IOException {
        super(in);
        this.requiredSize = InternalSignificantTerms.readSize(in);
        this.minDocCount = in.readVLong();
    }

    @Override
    protected final void doWriteTo(StreamOutput out) throws IOException {
        InternalSignificantTerms.writeSize(this.requiredSize, out);
        out.writeVLong(this.minDocCount);
        this.writeTermTypeInfoTo(out);
    }

    protected abstract void writeTermTypeInfoTo(StreamOutput var1) throws IOException;

    @Override
    public abstract List<B> getBuckets();

    @Override
    protected AggregatorReducer getLeaderReducer(final AggregationReduceContext reduceContext, final int size) {
        return new AggregatorReducer(){
            long globalSubsetSize = 0L;
            long globalSupersetSize = 0L;
            final ObjectObjectPagedHashMap<String, ReducerAndExtraInfo<B>> buckets = new ObjectObjectPagedHashMap(InternalSignificantTerms.this.getBuckets().size(), reduceContext.bigArrays());
            private InternalAggregation referenceAgg = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void accept(InternalAggregation aggregation) {
                if (!aggregation.canLeadReduction()) {
                    return;
                }
                InternalSignificantTerms terms = (InternalSignificantTerms)aggregation;
                if (this.referenceAgg == null) {
                    this.referenceAgg = terms;
                } else if (!this.referenceAgg.getClass().equals(terms.getClass())) {
                    throw AggregationErrors.reduceTypeMismatch(this.referenceAgg.getName(), Optional.empty());
                }
                this.globalSubsetSize += terms.getSubsetSize();
                this.globalSupersetSize += terms.getSupersetSize();
                for (Bucket bucket : terms.getBuckets()) {
                    ReducerAndExtraInfo<Object> reducerAndExtraInfo = this.buckets.get(bucket.getKeyAsString());
                    if (reducerAndExtraInfo == null) {
                        reducerAndExtraInfo = new ReducerAndExtraInfo<Bucket>(new BucketReducer<Bucket>(bucket, reduceContext, size));
                        boolean success = false;
                        try {
                            this.buckets.put(bucket.getKeyAsString(), reducerAndExtraInfo);
                            success = true;
                        }
                        finally {
                            if (!success) {
                                Releasables.close(reducerAndExtraInfo.reducer);
                            }
                        }
                    }
                    reducerAndExtraInfo.reducer.accept(bucket);
                    reducerAndExtraInfo.subsetDf[0] = reducerAndExtraInfo.subsetDf[0] + bucket.subsetDf;
                    reducerAndExtraInfo.supersetDf[0] = reducerAndExtraInfo.supersetDf[0] + bucket.supersetDf;
                }
            }

            @Override
            public InternalAggregation get() {
                SignificanceHeuristic heuristic = InternalSignificantTerms.this.getSignificanceHeuristic().rewrite(reduceContext);
                int size2 = (int)(!reduceContext.isFinalReduce() ? this.buckets.size() : Math.min((long)InternalSignificantTerms.this.requiredSize, this.buckets.size()));
                try (ObjectArrayPriorityQueue ordered = new ObjectArrayPriorityQueue<B>(this, size2, reduceContext.bigArrays()){

                    @Override
                    protected boolean lessThan(B a, B b) {
                        return ((Bucket)a).getSignificanceScore() < ((Bucket)b).getSignificanceScore();
                    }
                };){
                    this.buckets.forEach(entry -> {
                        Bucket b = InternalSignificantTerms.this.createBucket(((ReducerAndExtraInfo)entry.value).subsetDf[0], ((ReducerAndExtraInfo)entry.value).supersetDf[0], ((ReducerAndExtraInfo)entry.value).reducer.getAggregations(), (Bucket)((ReducerAndExtraInfo)entry.value).reducer.getProto());
                        b.updateScore(heuristic, this.globalSubsetSize, this.globalSupersetSize);
                        if (b.score > 0.0 && b.subsetDf >= InternalSignificantTerms.this.minDocCount || !reduceContext.isFinalReduce()) {
                            Bucket removed = ordered.insertWithOverflow(b);
                            if (removed == null) {
                                reduceContext.consumeBucketsAndMaybeBreak(1);
                            } else {
                                reduceContext.consumeBucketsAndMaybeBreak(-InternalMultiBucketAggregation.countInnerBucket(removed));
                            }
                        } else {
                            reduceContext.consumeBucketsAndMaybeBreak(-InternalMultiBucketAggregation.countInnerBucket(b));
                        }
                    });
                    Bucket[] list = InternalSignificantTerms.this.createBucketsArray((int)ordered.size());
                    for (int i = (int)ordered.size() - 1; i >= 0; --i) {
                        list[i] = (Bucket)ordered.pop();
                    }
                    Object a = InternalSignificantTerms.this.create(this.globalSubsetSize, this.globalSupersetSize, Arrays.asList(list));
                    return a;
                }
            }

            @Override
            public void close() {
                this.buckets.forEach(entry -> Releasables.close(((ReducerAndExtraInfo)entry.value).reducer));
                Releasables.close(this.buckets);
            }
        };
    }

    @Override
    public InternalAggregation finalizeSampling(SamplingContext samplingContext) {
        long supersetSize = samplingContext.scaleUp(this.getSupersetSize());
        long subsetSize = samplingContext.scaleUp(this.getSubsetSize());
        List<B> originalBuckets = this.getBuckets();
        ArrayList<Bucket> buckets = new ArrayList<Bucket>(originalBuckets.size());
        for (Bucket bucket : originalBuckets) {
            buckets.add(this.createBucket(samplingContext.scaleUp(bucket.subsetDf), samplingContext.scaleUp(bucket.supersetDf), InternalAggregations.finalizeSampling(bucket.aggregations, samplingContext), bucket));
        }
        return this.create(subsetSize, supersetSize, buckets);
    }

    abstract B createBucket(long var1, long var3, InternalAggregations var5, B var6);

    protected abstract A create(long var1, long var3, List<B> var5);

    protected abstract B[] createBucketsArray(int var1);

    protected abstract SignificanceHeuristic getSignificanceHeuristic();

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.minDocCount, this.requiredSize);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalSignificantTerms that = (InternalSignificantTerms)obj;
        return Objects.equals(this.minDocCount, that.minDocCount) && Objects.equals(this.requiredSize, that.requiredSize);
    }

    public static abstract class Bucket<B extends Bucket<B>>
    extends InternalMultiBucketAggregation.InternalBucketWritable
    implements SignificantTerms.Bucket {
        long subsetDf;
        long supersetDf;
        double score;
        protected InternalAggregations aggregations;
        final transient DocValueFormat format;

        protected Bucket(long subsetDf, long supersetDf, InternalAggregations aggregations, DocValueFormat format) {
            this.subsetDf = subsetDf;
            this.supersetDf = supersetDf;
            this.aggregations = aggregations;
            this.format = format;
        }

        protected Bucket(DocValueFormat format) {
            this.format = format;
        }

        @Override
        public long getSubsetDf() {
            return this.subsetDf;
        }

        @Override
        public long getSupersetDf() {
            return this.supersetDf;
        }

        void updateScore(SignificanceHeuristic significanceHeuristic, long subsetSize, long supersetSize) {
            this.score = significanceHeuristic.getScore(this.subsetDf, subsetSize, this.supersetDf, supersetSize);
        }

        @Override
        public long getDocCount() {
            return this.subsetDf;
        }

        @Override
        public InternalAggregations getAggregations() {
            return this.aggregations;
        }

        @Override
        public double getSignificanceScore() {
            return this.score;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Bucket that = (Bucket)o;
            return Double.compare(that.score, this.score) == 0 && Objects.equals(this.aggregations, that.aggregations) && Objects.equals(this.format, that.format);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.aggregations, this.score, this.format);
        }

        final void bucketToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.keyToXContent(builder);
            builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.getDocCount());
            builder.field(InternalSignificantTerms.SCORE, this.score);
            builder.field(InternalSignificantTerms.BG_COUNT, this.supersetDf);
            this.aggregations.toXContentInternal(builder, params);
            builder.endObject();
        }

        protected abstract XContentBuilder keyToXContent(XContentBuilder var1) throws IOException;

        @FunctionalInterface
        public static interface Reader<B extends Bucket<B>> {
            public B read(StreamInput var1, DocValueFormat var2) throws IOException;
        }
    }

    private record ReducerAndExtraInfo<B extends MultiBucketsAggregation.Bucket>(BucketReducer<B> reducer, long[] subsetDf, long[] supersetDf) {
        private ReducerAndExtraInfo(BucketReducer<B> reducer) {
            this(reducer, new long[]{0L}, new long[]{0L});
        }
    }
}

