/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.prefix;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.AggregatorReducer;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.KeyComparable;
import org.elasticsearch.search.aggregations.bucket.BucketReducer;
import org.elasticsearch.search.aggregations.bucket.IteratorAndCurrent;
import org.elasticsearch.search.aggregations.bucket.prefix.IpPrefix;
import org.elasticsearch.search.aggregations.bucket.prefix.IpPrefixAggregationBuilder;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class InternalIpPrefix
extends InternalMultiBucketAggregation<InternalIpPrefix, Bucket> {
    protected final DocValueFormat format;
    protected final boolean keyed;
    protected final long minDocCount;
    private final List<Bucket> buckets;

    public InternalIpPrefix(String name, DocValueFormat format, boolean keyed, long minDocCount, List<Bucket> buckets, Map<String, Object> metadata) {
        super(name, metadata);
        this.keyed = keyed;
        this.minDocCount = minDocCount;
        this.format = format;
        this.buckets = buckets;
    }

    public InternalIpPrefix(StreamInput in) throws IOException {
        super(in);
        this.format = in.readNamedWriteable(DocValueFormat.class);
        this.keyed = in.readBoolean();
        this.minDocCount = in.readVLong();
        this.buckets = in.readCollectionAsList(Bucket::new);
    }

    @Override
    public String getWriteableName() {
        return "ip_prefix";
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.format);
        out.writeBoolean(this.keyed);
        out.writeVLong(this.minDocCount);
        out.writeCollection(this.buckets);
    }

    @Override
    protected AggregatorReducer getLeaderReducer(final AggregationReduceContext reduceContext, final int size) {
        return new AggregatorReducer(){
            private final PriorityQueue<IteratorAndCurrent<Bucket>> pq;
            {
                this.pq = new PriorityQueue<IteratorAndCurrent<Bucket>>(this, size){

                    protected boolean lessThan(IteratorAndCurrent<Bucket> a, IteratorAndCurrent<Bucket> b) {
                        return a.current().key.compareTo(b.current().key) < 0;
                    }
                };
            }

            @Override
            public void accept(InternalAggregation aggregation) {
                InternalIpPrefix ipPrefix = (InternalIpPrefix)aggregation;
                if (!ipPrefix.buckets.isEmpty()) {
                    this.pq.add(new IteratorAndCurrent<Bucket>(ipPrefix.buckets.iterator()));
                }
            }

            @Override
            public InternalAggregation get() {
                List<Bucket> reducedBuckets = InternalIpPrefix.this.reduceBuckets(this.pq, reduceContext);
                reduceContext.consumeBucketsAndMaybeBreak(reducedBuckets.size());
                return new InternalIpPrefix(InternalIpPrefix.this.getName(), InternalIpPrefix.this.format, InternalIpPrefix.this.keyed, InternalIpPrefix.this.minDocCount, reducedBuckets, InternalIpPrefix.this.metadata);
            }
        };
    }

    private List<Bucket> reduceBuckets(PriorityQueue<IteratorAndCurrent<Bucket>> pq, AggregationReduceContext reduceContext) {
        ArrayList<Bucket> reducedBuckets = new ArrayList<Bucket>();
        if (pq.size() > 0) {
            ArrayList<Bucket> currentBuckets = new ArrayList<Bucket>();
            BytesRef value = ((Bucket)((IteratorAndCurrent)pq.top()).current()).key;
            do {
                IteratorAndCurrent top = (IteratorAndCurrent)pq.top();
                if (!((Bucket)top.current()).key.equals((Object)value)) {
                    Bucket reduced = this.reduceBucket(currentBuckets, reduceContext);
                    if (!reduceContext.isFinalReduce() || reduced.getDocCount() >= this.minDocCount) {
                        reducedBuckets.add(reduced);
                    }
                    currentBuckets.clear();
                    value = ((Bucket)top.current()).key;
                }
                currentBuckets.add((Bucket)top.current());
                if (top.hasNext()) {
                    top.next();
                    assert (((Bucket)top.current()).key.compareTo(value) > 0) : "shards must return data sorted by value [" + String.valueOf(((Bucket)top.current()).key) + "] and [" + String.valueOf(value) + "]";
                    pq.updateTop();
                    continue;
                }
                pq.pop();
            } while (pq.size() > 0);
            if (!currentBuckets.isEmpty()) {
                Bucket reduced = this.reduceBucket(currentBuckets, reduceContext);
                if (!reduceContext.isFinalReduce() || reduced.getDocCount() >= this.minDocCount) {
                    reducedBuckets.add(reduced);
                }
            }
        }
        return reducedBuckets;
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.keyed) {
            builder.startObject(Aggregation.CommonFields.BUCKETS.getPreferredName());
        } else {
            builder.startArray(Aggregation.CommonFields.BUCKETS.getPreferredName());
        }
        for (Bucket bucket : this.buckets) {
            bucket.bucketToXContent(builder, params, this.keyed);
        }
        if (this.keyed) {
            builder.endObject();
        } else {
            builder.endArray();
        }
        return builder;
    }

    @Override
    public InternalIpPrefix create(List<Bucket> buckets) {
        return new InternalIpPrefix(this.name, this.format, this.keyed, this.minDocCount, buckets, this.metadata);
    }

    @Override
    public Bucket createBucket(InternalAggregations aggregations, Bucket prototype) {
        return new Bucket(prototype.key, prototype.isIpv6, prototype.prefixLength, prototype.appendPrefixLength, prototype.docCount, prototype.aggregations);
    }

    private Bucket createBucket(Bucket prototype, InternalAggregations aggregations, long docCount) {
        return new Bucket(prototype.key, prototype.isIpv6, prototype.prefixLength, prototype.appendPrefixLength, docCount, aggregations);
    }

    private Bucket reduceBucket(List<Bucket> buckets, AggregationReduceContext context) {
        assert (!buckets.isEmpty());
        try (BucketReducer<Bucket> reducer = new BucketReducer<Bucket>(buckets.get(0), context, buckets.size());){
            for (Bucket bucket : buckets) {
                reducer.accept(bucket);
            }
            Bucket bucket = this.createBucket(reducer.getProto(), reducer.getAggregations(), reducer.getDocCount());
            return bucket;
        }
    }

    @Override
    public List<Bucket> getBuckets() {
        return Collections.unmodifiableList(this.buckets);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InternalIpPrefix that = (InternalIpPrefix)o;
        return this.minDocCount == that.minDocCount && Objects.equals(this.format, that.format) && Objects.equals(this.buckets, that.buckets);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.format, this.minDocCount, this.buckets);
    }

    public static class Bucket
    extends InternalMultiBucketAggregation.InternalBucketWritable
    implements IpPrefix.Bucket,
    KeyComparable<Bucket> {
        private final BytesRef key;
        private final boolean isIpv6;
        private final int prefixLength;
        private final boolean appendPrefixLength;
        private final long docCount;
        private final InternalAggregations aggregations;

        public Bucket(BytesRef key, boolean isIpv6, int prefixLength, boolean appendPrefixLength, long docCount, InternalAggregations aggregations) {
            this.key = key;
            this.isIpv6 = isIpv6;
            this.prefixLength = prefixLength;
            this.appendPrefixLength = appendPrefixLength;
            this.docCount = docCount;
            this.aggregations = aggregations;
        }

        public Bucket(StreamInput in) throws IOException {
            this.key = in.readBytesRef();
            this.isIpv6 = in.readBoolean();
            this.prefixLength = in.readVInt();
            this.appendPrefixLength = in.readBoolean();
            this.docCount = in.readLong();
            this.aggregations = InternalAggregations.readFrom(in);
        }

        private void bucketToXContent(XContentBuilder builder, ToXContent.Params params, boolean keyed) throws IOException {
            Object key = DocValueFormat.IP.format(this.key);
            if (this.appendPrefixLength) {
                key = (String)key + "/" + this.prefixLength;
            }
            if (keyed) {
                builder.startObject((String)key);
            } else {
                builder.startObject();
                builder.field(Aggregation.CommonFields.KEY.getPreferredName(), (String)key);
            }
            if (!this.isIpv6) {
                builder.field("netmask", DocValueFormat.IP.format(Bucket.netmask(this.prefixLength)));
            }
            builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.docCount);
            builder.field(IpPrefixAggregationBuilder.IS_IPV6_FIELD.getPreferredName(), this.isIpv6);
            builder.field(IpPrefixAggregationBuilder.PREFIX_LENGTH_FIELD.getPreferredName(), this.prefixLength);
            this.aggregations.toXContentInternal(builder, params);
            builder.endObject();
        }

        private static BytesRef netmask(int prefixLength) {
            return IpPrefixAggregationBuilder.extractNetmask(prefixLength, false);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeBytesRef(this.key);
            out.writeBoolean(this.isIpv6);
            out.writeVInt(this.prefixLength);
            out.writeBoolean(this.appendPrefixLength);
            out.writeLong(this.docCount);
            this.aggregations.writeTo(out);
        }

        public BytesRef getKey() {
            return this.key;
        }

        @Override
        public String getKeyAsString() {
            return DocValueFormat.IP.format(this.key);
        }

        public boolean isIpv6() {
            return this.isIpv6;
        }

        public int getPrefixLength() {
            return this.prefixLength;
        }

        public boolean appendPrefixLength() {
            return this.appendPrefixLength;
        }

        @Override
        public long getDocCount() {
            return this.docCount;
        }

        @Override
        public InternalAggregations getAggregations() {
            return this.aggregations;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Bucket bucket = (Bucket)o;
            return this.isIpv6 == bucket.isIpv6 && this.prefixLength == bucket.prefixLength && this.appendPrefixLength == bucket.appendPrefixLength && this.docCount == bucket.docCount && Objects.equals(this.key, bucket.key) && Objects.equals(this.aggregations, bucket.aggregations);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.isIpv6, this.prefixLength, this.appendPrefixLength, this.docCount, this.aggregations);
        }

        @Override
        public int compareKey(Bucket other) {
            return this.key.compareTo(other.key);
        }
    }
}

