/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.util.Map;
import java.util.PrimitiveIterator;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.index.mapper.OnScriptError;
import org.elasticsearch.script.AbstractLongFieldScript;
import org.elasticsearch.script.field.LongDocValuesField;
import org.elasticsearch.search.lookup.SearchLookup;

public class SortedNumericDocValuesLongFieldScript
extends AbstractLongFieldScript {
    final LongDocValuesField longDocValuesField;

    public SortedNumericDocValuesLongFieldScript(String fieldName, SearchLookup lookup, LeafReaderContext ctx) {
        super(fieldName, Map.of(), lookup, OnScriptError.FAIL, ctx);
        try {
            this.longDocValuesField = new LongDocValuesField(DocValues.getSortedNumeric((LeafReader)ctx.reader(), (String)fieldName), fieldName);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load doc values", e);
        }
    }

    @Override
    protected void emitFromObject(Object v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDocument(int docID) {
        try {
            this.longDocValuesField.setNextDocId(docID);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load doc values", e);
        }
    }

    @Override
    public void execute() {
        PrimitiveIterator.OfLong ofLong = this.longDocValuesField.iterator();
        while (ofLong.hasNext()) {
            long value = (Long)ofLong.next();
            this.emit(value);
        }
    }
}

