/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging.internal;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.elasticsearch.common.SuppressLoggerChecks;
import org.elasticsearch.common.logging.internal.LevelUtil;
import org.elasticsearch.logging.Level;

@SuppressLoggerChecks(reason="safely delegates to logger")
public final class LoggerImpl
implements org.elasticsearch.logging.Logger {
    private final Logger log4jLogger;

    public LoggerImpl(Logger log4jLogger) {
        this.log4jLogger = log4jLogger;
    }

    private static Supplier<?> mapSupplier(java.util.function.Supplier<String> msgSupplier) {
        return () -> msgSupplier.get();
    }

    public void log(Level level, String message) {
        this.log4jLogger.log(LevelUtil.log4jLevel(level), message);
    }

    public void log(Level level, java.util.function.Supplier<String> messageSupplier, Throwable throwable) {
        this.log4jLogger.log(LevelUtil.log4jLevel(level), LoggerImpl.mapSupplier(messageSupplier), throwable);
    }

    public String getName() {
        return this.log4jLogger.getName();
    }

    public boolean isFatalEnabled() {
        return this.log4jLogger.isFatalEnabled();
    }

    public boolean isErrorEnabled() {
        return this.log4jLogger.isErrorEnabled();
    }

    public boolean isWarnEnabled() {
        return this.log4jLogger.isWarnEnabled();
    }

    public boolean isInfoEnabled() {
        return this.log4jLogger.isInfoEnabled();
    }

    public boolean isDebugEnabled() {
        return this.log4jLogger.isDebugEnabled();
    }

    public boolean isTraceEnabled() {
        return this.log4jLogger.isTraceEnabled();
    }

    public boolean isEnabled(Level level) {
        return this.log4jLogger.isEnabled(LevelUtil.log4jLevel(level));
    }

    public void fatal(java.util.function.Supplier<String> messageSupplier) {
        this.log4jLogger.fatal(LoggerImpl.mapSupplier(messageSupplier));
    }

    public void fatal(java.util.function.Supplier<String> messageSupplier, Throwable throwable) {
        this.log4jLogger.fatal(LoggerImpl.mapSupplier(messageSupplier), throwable);
    }

    public void fatal(String message) {
        this.log4jLogger.fatal(message);
    }

    public void fatal(String message, Throwable throwable) {
        this.log4jLogger.fatal(message, throwable);
    }

    public void fatal(String message, Object ... params) {
        this.log4jLogger.fatal(message, params);
    }

    public void error(java.util.function.Supplier<String> messageSupplier) {
        this.log4jLogger.error(LoggerImpl.mapSupplier(messageSupplier));
    }

    public void error(java.util.function.Supplier<String> messageSupplier, Throwable throwable) {
        this.log4jLogger.error(LoggerImpl.mapSupplier(messageSupplier), throwable);
    }

    public void error(String message) {
        this.log4jLogger.error(message);
    }

    public void error(String message, Throwable throwable) {
        this.log4jLogger.error(message, throwable);
    }

    public void error(String message, Object ... params) {
        this.log4jLogger.error(message, params);
    }

    public void warn(java.util.function.Supplier<String> messageSupplier) {
        this.log4jLogger.warn(LoggerImpl.mapSupplier(messageSupplier));
    }

    public void warn(java.util.function.Supplier<String> messageSupplier, Throwable throwable) {
        this.log4jLogger.warn(LoggerImpl.mapSupplier(messageSupplier), throwable);
    }

    public void warn(String message) {
        this.log4jLogger.warn(message);
    }

    public void warn(String message, Throwable throwable) {
        this.log4jLogger.warn(message, throwable);
    }

    public void warn(String message, Object ... params) {
        this.log4jLogger.warn(message, params);
    }

    public void info(java.util.function.Supplier<String> messageSupplier) {
        this.log4jLogger.info(LoggerImpl.mapSupplier(messageSupplier));
    }

    public void info(java.util.function.Supplier<String> messageSupplier, Throwable throwable) {
        this.log4jLogger.info(LoggerImpl.mapSupplier(messageSupplier), throwable);
    }

    public void info(String message) {
        this.log4jLogger.info(message);
    }

    public void info(String message, Throwable throwable) {
        this.log4jLogger.info(message, throwable);
    }

    public void info(String message, Object ... params) {
        this.log4jLogger.info(message, params);
    }

    public void debug(java.util.function.Supplier<String> messageSupplier) {
        this.log4jLogger.debug(LoggerImpl.mapSupplier(messageSupplier));
    }

    public void debug(java.util.function.Supplier<String> messageSupplier, Throwable throwable) {
        this.log4jLogger.debug(LoggerImpl.mapSupplier(messageSupplier), throwable);
    }

    public void debug(String message) {
        this.log4jLogger.debug(message);
    }

    public void debug(String message, Throwable throwable) {
        this.log4jLogger.debug(message, throwable);
    }

    public void debug(String message, Object ... params) {
        this.log4jLogger.debug(message, params);
    }

    public void trace(java.util.function.Supplier<String> messageSupplier) {
        this.log4jLogger.trace(LoggerImpl.mapSupplier(messageSupplier));
    }

    public void trace(java.util.function.Supplier<String> messageSupplier, Throwable throwable) {
        this.log4jLogger.trace(LoggerImpl.mapSupplier(messageSupplier), throwable);
    }

    public void trace(String message) {
        this.log4jLogger.trace(message);
    }

    public void trace(String message, Throwable throwable) {
        this.log4jLogger.trace(message, throwable);
    }

    public void trace(String message, Object ... params) {
        this.log4jLogger.trace(message, params);
    }
}

