/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.shutdown;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public record NodesRemovalPrevalidation(boolean isSafe, String message, List<NodeResult> nodes) implements ToXContentObject,
Writeable
{
    private static final ParseField IS_SAFE_FIELD = new ParseField("is_safe", new String[0]);
    private static final ParseField MESSAGE_FIELD = new ParseField("message", new String[0]);
    private static final ParseField NODES_FIELD = new ParseField("nodes", new String[0]);
    public static final ConstructingObjectParser<NodesRemovalPrevalidation, Void> PARSER = new ConstructingObjectParser("nodes_removal_prevalidation", objects -> new NodesRemovalPrevalidation((Boolean)objects[0], (String)objects[1], (List)objects[2]));

    static <T> void configureParser(ConstructingObjectParser<T, Void> parser) {
        parser.declareBoolean(ConstructingObjectParser.constructorArg(), IS_SAFE_FIELD);
        parser.declareString(ConstructingObjectParser.constructorArg(), MESSAGE_FIELD);
        parser.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> NodeResult.fromXContent(p), NODES_FIELD);
    }

    public static NodesRemovalPrevalidation readFrom(StreamInput in) throws IOException {
        return new NodesRemovalPrevalidation(in.readBoolean(), in.readString(), in.readCollectionAsList(NodeResult::readFrom));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.isSafe);
        out.writeString(this.message);
        out.writeCollection(this.nodes);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(IS_SAFE_FIELD.getPreferredName(), this.isSafe);
        builder.field(MESSAGE_FIELD.getPreferredName(), this.message);
        builder.xContentList(NODES_FIELD.getPreferredName(), this.nodes, params);
        return builder.endObject();
    }

    public static NodesRemovalPrevalidation fromXContent(XContentParser parser) throws IOException {
        return (NodesRemovalPrevalidation)PARSER.parse(parser, null);
    }

    static {
        NodesRemovalPrevalidation.configureParser(PARSER);
    }

    public record NodeResult(String name, String Id, String externalId, Result result) implements ToXContentObject,
    Writeable
    {
        private static final ParseField NAME_FIELD = new ParseField("name", new String[0]);
        private static final ParseField ID_FIELD = new ParseField("id", new String[0]);
        private static final ParseField EXTERNAL_ID_FIELD = new ParseField("external_id", new String[0]);
        private static final ParseField RESULT_FIELD = new ParseField("result", new String[0]);
        private static final ConstructingObjectParser<NodeResult, Void> PARSER = new ConstructingObjectParser("nodes_removal_prevalidation_node_result", objects -> new NodeResult((String)objects[0], (String)objects[1], (String)objects[2], (Result)objects[3]));

        static <T> void configureParser(ConstructingObjectParser<T, Void> parser) {
            parser.declareString(ConstructingObjectParser.constructorArg(), NAME_FIELD);
            parser.declareString(ConstructingObjectParser.constructorArg(), ID_FIELD);
            parser.declareString(ConstructingObjectParser.constructorArg(), EXTERNAL_ID_FIELD);
            parser.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> Result.fromXContent(p), RESULT_FIELD);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.name);
            out.writeString(this.Id);
            out.writeString(this.externalId);
            this.result.writeTo(out);
        }

        public static NodeResult readFrom(StreamInput in) throws IOException {
            return new NodeResult(in.readString(), in.readString(), in.readString(), Result.readFrom(in));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(NAME_FIELD.getPreferredName(), this.name);
            builder.field(ID_FIELD.getPreferredName(), this.Id);
            builder.field(EXTERNAL_ID_FIELD.getPreferredName(), this.externalId);
            builder.field(RESULT_FIELD.getPreferredName(), (ToXContent)this.result);
            builder.endObject();
            return builder;
        }

        public static NodeResult fromXContent(XContentParser parser) throws IOException {
            return (NodeResult)PARSER.parse(parser, null);
        }

        static {
            NodeResult.configureParser(PARSER);
        }
    }

    public static enum Reason implements Writeable
    {
        NO_PROBLEMS("no_problems"),
        NO_RED_SHARDS_ON_NODE("no_red_shards_on_node"),
        NO_RED_SHARDS_EXCEPT_SEARCHABLE_SNAPSHOTS("no_red_shards_except_searchable_snapshots"),
        RED_SHARDS_ON_NODE("red_shards_on_node"),
        UNABLE_TO_VERIFY("unable_to_verify_red_shards");

        private final String reason;

        private Reason(String reason) {
            this.reason = reason;
        }

        public String reason() {
            return this.reason;
        }

        public static Reason readFrom(StreamInput in) throws IOException {
            return Reason.fromString(in.readString());
        }

        public static Reason fromString(String s) {
            for (Reason r : Reason.values()) {
                if (!s.equalsIgnoreCase(r.reason)) continue;
                return r;
            }
            throw new IllegalArgumentException("unexpected Reason value [" + s + "]");
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.reason);
        }
    }

    public record Result(boolean isSafe, @Nullable Reason reason, String message) implements ToXContentObject,
    Writeable
    {
        private static final ParseField IS_SAFE_FIELD = new ParseField("is_safe", new String[0]);
        private static final ParseField REASON_FIELD = new ParseField("reason", new String[0]);
        private static final ParseField MESSAGE_FIELD = new ParseField("message", new String[0]);
        private static final ConstructingObjectParser<Result, Void> PARSER = new ConstructingObjectParser("nodes_removal_prevalidation_result", objects -> new Result((Boolean)objects[0], Reason.fromString((String)objects[1]), (String)objects[2]));

        static <T> void configureParser(ConstructingObjectParser<T, Void> parser) {
            parser.declareBoolean(ConstructingObjectParser.constructorArg(), IS_SAFE_FIELD);
            parser.declareString(ConstructingObjectParser.constructorArg(), REASON_FIELD);
            parser.declareString(ConstructingObjectParser.constructorArg(), MESSAGE_FIELD);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this.isSafe);
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_7_0)) {
                this.reason.writeTo(out);
            }
            out.writeString(this.message);
        }

        public static Result readFrom(StreamInput in) throws IOException {
            if (in.getTransportVersion().before(TransportVersions.V_8_7_0)) {
                return new Result(in.readBoolean(), null, in.readString());
            }
            return new Result(in.readBoolean(), Reason.readFrom(in), in.readString());
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(IS_SAFE_FIELD.getPreferredName(), this.isSafe);
            if (this.reason != null) {
                builder.field(REASON_FIELD.getPreferredName(), this.reason.reason);
            }
            builder.field(MESSAGE_FIELD.getPreferredName(), this.message);
            builder.endObject();
            return builder;
        }

        public static Result fromXContent(XContentParser parser) throws IOException {
            return (Result)PARSER.parse(parser, null);
        }

        static {
            Result.configureParser(PARSER);
        }
    }
}

