/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.migrate.task;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public record ReindexDataStreamTaskParams(String sourceDataStream, long startTime, int totalIndices, int totalIndicesToBeUpgraded, Map<String, String> headers) implements PersistentTaskParams
{
    private static final String API_CONTEXT = Metadata.XContentContext.API.toString();
    public static final String NAME = "reindex-data-stream";
    private static final String SOURCE_DATA_STREAM_FIELD = "source_data_stream";
    private static final String START_TIME_FIELD = "start_time";
    private static final String TOTAL_INDICES_FIELD = "total_indices";
    private static final String TOTAL_INDICES_TO_BE_UPGRADED_FIELD = "total_indices_to_be_upgraded";
    private static final String HEADERS_FIELD = "headers";
    private static final ConstructingObjectParser<ReindexDataStreamTaskParams, Void> PARSER = new ConstructingObjectParser("reindex-data-stream", true, args -> new ReindexDataStreamTaskParams((String)args[0], (Long)args[1], (Integer)args[2], (Integer)args[3], args[4] == null ? Map.of() : (Map)args[4]));

    public ReindexDataStreamTaskParams(StreamInput in) throws IOException {
        this(in.readString(), in.readLong(), in.readInt(), in.readInt(), (Map)in.readGenericValue());
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.REINDEX_DATA_STREAMS;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.sourceDataStream);
        out.writeLong(this.startTime);
        out.writeInt(this.totalIndices);
        out.writeInt(this.totalIndicesToBeUpgraded);
        out.writeGenericValue(this.headers);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field(SOURCE_DATA_STREAM_FIELD, this.sourceDataStream).field(START_TIME_FIELD, this.startTime).field(TOTAL_INDICES_FIELD, this.totalIndices).field(TOTAL_INDICES_TO_BE_UPGRADED_FIELD, this.totalIndicesToBeUpgraded);
        if (!API_CONTEXT.equals(params.param("context_mode", API_CONTEXT))) {
            builder.stringStringMap(HEADERS_FIELD, this.headers);
        }
        builder.endObject();
        return builder;
    }

    public String getSourceDataStream() {
        return this.sourceDataStream;
    }

    public static ReindexDataStreamTaskParams fromXContent(XContentParser parser) {
        return (ReindexDataStreamTaskParams)PARSER.apply(parser, null);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(SOURCE_DATA_STREAM_FIELD, new String[0]));
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField(START_TIME_FIELD, new String[0]));
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(TOTAL_INDICES_FIELD, new String[0]));
        PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(TOTAL_INDICES_TO_BE_UPGRADED_FIELD, new String[0]));
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), XContentParser::mapStrings, new ParseField(HEADERS_FIELD, new String[0]), ObjectParser.ValueType.OBJECT);
    }
}

