/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.system_indices.task;

import java.util.stream.Stream;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.indices.SystemDataStreamDescriptor;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.system_indices.task.SystemResourceMigrationInfo;

final class SystemDataStreamMigrationInfo
extends SystemResourceMigrationInfo {
    private final DataStream dataStream;
    private final String dataStreamName;

    private SystemDataStreamMigrationInfo(DataStream dataStream, String dataStreamName, String featureName, String origin, SystemIndices.Feature owningFeature) {
        super(featureName, origin, owningFeature);
        this.dataStreamName = dataStreamName;
        this.dataStream = dataStream;
    }

    public static SystemDataStreamMigrationInfo build(DataStream dataStream, SystemDataStreamDescriptor dataStreamDescriptor, SystemIndices.Feature feature) {
        return new SystemDataStreamMigrationInfo(dataStream, dataStreamDescriptor.getDataStreamName(), feature.getName(), dataStreamDescriptor.getOrigin(), feature);
    }

    public String getDataStreamName() {
        return this.dataStreamName;
    }

    @Override
    protected String getCurrentResourceName() {
        return this.getDataStreamName();
    }

    @Override
    Stream<IndexMetadata> getIndices(Metadata metadata) {
        return Stream.concat(this.dataStream.getIndices().stream(), this.dataStream.getFailureIndices().stream()).map(arg_0 -> ((Metadata)metadata).getIndexSafe(arg_0));
    }

    @Override
    boolean isCurrentIndexClosed() {
        return false;
    }
}

