/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.util;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import org.elasticsearch.common.time.DateFormatters;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Foldables;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.sql.parser.ParsingException;
import org.elasticsearch.xpack.sql.proto.StringUtils;
import org.elasticsearch.xpack.sql.type.SqlDataTypeConverter;

public final class DateUtils {
    public static final ZoneId UTC = ZoneId.of("Z");
    public static final LocalDate EPOCH = LocalDate.of(1970, 1, 1);
    public static final long DAY_IN_MILLIS = 86400000L;
    private static final DateTimeFormatter ISO_LOCAL_TIME_OPTIONAL_TZ = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_TIME).optionalStart().appendZoneOrOffsetId().toFormatter(Locale.ROOT).withZone(UTC);
    private static final DateTimeFormatter ISO_LOCAL_DATE_OPTIONAL_TIME_FORMATTER_WHITESPACE = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalStart().appendLiteral(' ').append(ISO_LOCAL_TIME_OPTIONAL_TZ).optionalEnd().toFormatter(Locale.ROOT).withZone(UTC);
    private static final DateTimeFormatter ISO_LOCAL_DATE_OPTIONAL_TIME_FORMATTER_T_LITERAL = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalStart().appendLiteral('T').append(ISO_LOCAL_TIME_OPTIONAL_TZ).optionalEnd().toFormatter(Locale.ROOT).withZone(UTC);
    private static final int DEFAULT_PRECISION_FOR_CURRENT_FUNCTIONS = 3;

    private DateUtils() {
    }

    public static ZonedDateTime asDateOnly(long millis) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(millis), UTC).toLocalDate().atStartOfDay(UTC);
    }

    public static OffsetTime asTimeOnly(long millis) {
        return OffsetTime.ofInstant(Instant.ofEpochMilli(millis % 86400000L), UTC);
    }

    public static OffsetTime asTimeOnly(long millis, ZoneId zoneId) {
        return OffsetTime.ofInstant(Instant.ofEpochMilli(millis % 86400000L), zoneId);
    }

    public static OffsetTime asTimeAtZone(OffsetTime time, ZoneId zonedId) {
        return time.atDate(EPOCH).atZoneSameInstant(zonedId).toOffsetDateTime().toOffsetTime();
    }

    public static ZonedDateTime asDateTimeWithMillis(long millis) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(millis), UTC);
    }

    public static ZonedDateTime asDateTimeWithMillis(long millis, ZoneId id) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(millis), id);
    }

    public static ZonedDateTime asDateOnly(String dateFormat) {
        int separatorIdx = DateUtils.timeSeparatorIdx(dateFormat);
        if (separatorIdx >= dateFormat.length() || dateFormat.charAt(separatorIdx) == 'T') {
            return LocalDate.parse(dateFormat, ISO_LOCAL_DATE_OPTIONAL_TIME_FORMATTER_T_LITERAL).atStartOfDay(UTC);
        }
        return LocalDate.parse(dateFormat, ISO_LOCAL_DATE_OPTIONAL_TIME_FORMATTER_WHITESPACE).atStartOfDay(UTC);
    }

    public static ZonedDateTime asDateOnly(ZonedDateTime zdt) {
        return zdt.toLocalDate().atStartOfDay(zdt.getZone());
    }

    public static OffsetTime asTimeOnly(String timeFormat) {
        return DateFormatters.from((TemporalAccessor)ISO_LOCAL_TIME_OPTIONAL_TZ.parse(timeFormat)).toOffsetDateTime().toOffsetTime();
    }

    public static ZonedDateTime asDateTimeWithNanos(String dateFormat) {
        return DateFormatters.from((TemporalAccessor)org.elasticsearch.xpack.ql.util.DateUtils.UTC_DATE_TIME_FORMATTER.parse(dateFormat)).withZoneSameInstant(UTC);
    }

    public static ZonedDateTime dateTimeOfEscapedLiteral(String dateFormat) {
        int separatorIdx = DateUtils.timeSeparatorIdx(dateFormat);
        if (separatorIdx >= dateFormat.length() || dateFormat.charAt(separatorIdx) == 'T') {
            return ZonedDateTime.parse(dateFormat, ISO_LOCAL_DATE_OPTIONAL_TIME_FORMATTER_T_LITERAL);
        }
        return ZonedDateTime.parse(dateFormat, ISO_LOCAL_DATE_OPTIONAL_TIME_FORMATTER_WHITESPACE);
    }

    public static String toString(ZonedDateTime dateTime) {
        return StringUtils.toString((Object)dateTime);
    }

    public static String toDateString(ZonedDateTime date) {
        return date.format(DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public static String toTimeString(OffsetTime time) {
        return StringUtils.toString((Object)time);
    }

    public static long minDayInterval(long l) {
        if (l < 86400000L) {
            return 86400000L;
        }
        return l - l % 86400000L;
    }

    public static int getNanoPrecision(Expression precisionExpression, int nano) {
        int precision = 3;
        if (precisionExpression != null) {
            try {
                precision = (Integer)SqlDataTypeConverter.convert(Foldables.valueOf((Expression)precisionExpression), DataTypes.INTEGER);
            }
            catch (Exception e) {
                throw new ParsingException(precisionExpression.source(), "invalid precision; " + e.getMessage(), new Object[0]);
            }
        }
        if (precision < 0 || precision > 9) {
            throw new ParsingException(precisionExpression.source(), "precision needs to be between [0-9], received [{}]", precisionExpression.sourceText());
        }
        nano -= nano % (int)Math.pow(10.0, 9 - precision);
        return nano;
    }

    public static ZonedDateTime atTimeZone(LocalDate ld, ZoneId zoneId) {
        return ld.atStartOfDay(zoneId);
    }

    public static ZonedDateTime atTimeZone(LocalDateTime ldt, ZoneId zoneId) {
        return ZonedDateTime.ofInstant(ldt, zoneId.getRules().getValidOffsets(ldt).get(0), zoneId);
    }

    public static OffsetTime atTimeZone(OffsetTime ot, ZoneId zoneId) {
        LocalDateTime ldt = ot.atDate(LocalDate.EPOCH).toLocalDateTime();
        return ot.withOffsetSameInstant(zoneId.getRules().getValidOffsets(ldt).get(0));
    }

    public static OffsetTime atTimeZone(LocalTime lt, ZoneId zoneId) {
        LocalDateTime ldt = lt.atDate(LocalDate.EPOCH);
        return OffsetTime.of(lt, zoneId.getRules().getValidOffsets(ldt).get(0));
    }

    public static ZonedDateTime atTimeZone(ZonedDateTime zdt, ZoneId zoneId) {
        return zdt.withZoneSameInstant(zoneId);
    }

    public static TemporalAccessor atTimeZone(TemporalAccessor ta, ZoneId zoneId) {
        if (ta instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)ta;
            return DateUtils.atTimeZone(localDateTime, zoneId);
        }
        if (ta instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)ta;
            return DateUtils.atTimeZone(zonedDateTime, zoneId);
        }
        if (ta instanceof OffsetTime) {
            OffsetTime offsetTime = (OffsetTime)ta;
            return DateUtils.atTimeZone(offsetTime, zoneId);
        }
        if (ta instanceof LocalTime) {
            LocalTime localTime = (LocalTime)ta;
            return DateUtils.atTimeZone(localTime, zoneId);
        }
        if (ta instanceof LocalDate) {
            LocalDate localDate = (LocalDate)ta;
            return DateUtils.atTimeZone(localDate, zoneId);
        }
        return ta;
    }

    private static int timeSeparatorIdx(String timestampStr) {
        int separatorIdx = timestampStr.indexOf(45);
        if (separatorIdx == 0) {
            separatorIdx = timestampStr.indexOf(45, 1);
        }
        return timestampStr.indexOf(45, separatorIdx + 1) + 3;
    }
}

