/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.util;

import org.elasticsearch.xpack.ql.InvalidArgumentException;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;

public abstract class Check {
    public static void isTrue(boolean expression, String message, Object ... values) {
        if (!expression) {
            throw new SqlIllegalArgumentException(message, values);
        }
    }

    public static void isTrue(boolean expression, String message) {
        if (!expression) {
            throw new SqlIllegalArgumentException(message);
        }
    }

    public static void notNull(Object object, String message, Object ... values) {
        if (object == null) {
            throw new SqlIllegalArgumentException(message, values);
        }
    }

    public static void isFixedNumberAndInRange(Object object, String objectName, Long from, Long to) {
        if (!(object instanceof Number) || object instanceof Float || object instanceof Double) {
            throw new InvalidArgumentException("A fixed point number is required for [{}]; received [{}]", new Object[]{objectName, object.getClass().getTypeName()});
        }
        Long longValue = ((Number)object).longValue();
        if (longValue < from || longValue > to) {
            throw new InvalidArgumentException("[{}] out of the allowed range [{}, {}], received [{}]", new Object[]{objectName, from, to, longValue});
        }
    }
}

