/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.geo;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.ql.expression.gen.processor.BinaryProcessor;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.literal.geo.GeoShape;

public class StDistanceProcessor
extends BinaryProcessor {
    public static final String NAME = "geo_distance";

    public StDistanceProcessor(Processor source1, Processor source2) {
        super(source1, source2);
    }

    public StDistanceProcessor(StreamInput in) throws IOException {
        super(in);
    }

    protected void doWrite(StreamOutput out) throws IOException {
    }

    public Object process(Object input) {
        Object l = this.left().process(input);
        this.checkParameter(l);
        Object r = this.right().process(input);
        this.checkParameter(r);
        return this.doProcess(l, r);
    }

    protected Object doProcess(Object left, Object right) {
        return StDistanceProcessor.process(left, right);
    }

    public static Double process(Object source1, Object source2) {
        if (source1 == null || source2 == null) {
            return null;
        }
        if (!(source1 instanceof GeoShape)) {
            throw new SqlIllegalArgumentException("A geo_point or geo_shape with type point is required; received [{}]", source1);
        }
        if (!(source2 instanceof GeoShape)) {
            throw new SqlIllegalArgumentException("A geo_point or geo_shape with type point is required; received [{}]", source2);
        }
        return GeoShape.distance((GeoShape)source1, (GeoShape)source2);
    }

    public String getWriteableName() {
        return NAME;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        StDistanceProcessor other = (StDistanceProcessor)((Object)obj);
        return Objects.equals(this.left(), other.left()) && Objects.equals(this.right(), other.right());
    }

    public int hashCode() {
        return Objects.hash(this.left(), this.right());
    }
}

