/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.io.IOException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.IsoFields;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalField;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.BaseDateTimeProcessor;

public class DateTimeProcessor
extends BaseDateTimeProcessor {
    public static final String NAME = "dt";
    private final DateTimeExtractor extractor;

    public DateTimeProcessor(DateTimeExtractor extractor, ZoneId zoneId) {
        super(zoneId);
        this.extractor = extractor;
    }

    public DateTimeProcessor(StreamInput in) throws IOException {
        super(in);
        this.extractor = (DateTimeExtractor)in.readEnum(DateTimeExtractor.class);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this.extractor);
    }

    public String getWriteableName() {
        return NAME;
    }

    DateTimeExtractor extractor() {
        return this.extractor;
    }

    @Override
    public Object doProcess(ZonedDateTime dateTime) {
        return this.extractor.extract(dateTime);
    }

    public static Integer doProcess(ZonedDateTime dateTime, String tzId, String extractorName) {
        ZonedDateTime zdt = dateTime.withZoneSameInstant(ZoneId.of(tzId));
        return DateTimeProcessor.doProcess(zdt, extractorName);
    }

    protected static Integer doProcess(Temporal dateTime, String extractorName) {
        return DateTimeExtractor.valueOf(extractorName).extract(dateTime);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.extractor, this.zoneId()});
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DateTimeProcessor other = (DateTimeProcessor)obj;
        return Objects.equals((Object)this.extractor, (Object)other.extractor) && Objects.equals(this.zoneId(), other.zoneId());
    }

    public String toString() {
        return this.extractor.toString();
    }

    public static enum DateTimeExtractor {
        DAY_OF_MONTH(ChronoField.DAY_OF_MONTH),
        ISO_DAY_OF_WEEK(ChronoField.DAY_OF_WEEK),
        DAY_OF_YEAR(ChronoField.DAY_OF_YEAR),
        HOUR_OF_DAY(ChronoField.HOUR_OF_DAY),
        MINUTE_OF_DAY(ChronoField.MINUTE_OF_DAY),
        MINUTE_OF_HOUR(ChronoField.MINUTE_OF_HOUR),
        MONTH_OF_YEAR(ChronoField.MONTH_OF_YEAR),
        SECOND_OF_MINUTE(ChronoField.SECOND_OF_MINUTE),
        ISO_WEEK_OF_YEAR(IsoFields.WEEK_OF_WEEK_BASED_YEAR),
        YEAR(ChronoField.YEAR);

        private final TemporalField field;

        private DateTimeExtractor(TemporalField field) {
            this.field = field;
        }

        public int extract(Temporal time) {
            return time.get(this.field);
        }
    }
}

