/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.blobcache.common;

import java.nio.ByteBuffer;
import java.util.concurrent.Semaphore;
import org.elasticsearch.core.Nullable;

public final class ByteBufferReference {
    private final Semaphore permits = new Semaphore(Integer.MAX_VALUE);
    private ByteBuffer buffer;

    public ByteBufferReference(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Nullable
    public ByteBuffer tryAcquire(int position, int length) {
        if (!this.permits.tryAcquire()) {
            return null;
        }
        return this.buffer.slice(this.buffer.position() + position, length);
    }

    public void release() {
        this.permits.release();
    }

    public void finish(int bytesRead) throws Exception {
        if (this.buffer != null) {
            assert (bytesRead == 0 || this.permits.availablePermits() == Integer.MAX_VALUE) : "Try to finish [" + bytesRead + "] but only had [" + this.permits.availablePermits() + "] permits available.";
            this.permits.acquire(Integer.MAX_VALUE);
            this.buffer.position(this.buffer.position() + bytesRead);
            this.buffer = null;
        }
    }
}

