/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.jdk;

import java.lang.module.ModuleDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;

public abstract class ModuleQualifiedExportsService {
    private static final Logger logger = LogManager.getLogger(ModuleQualifiedExportsService.class);
    protected final Module module;
    private final Map<String, List<String>> qualifiedExports;
    private final Map<String, List<String>> qualifiedOpens;
    private final Set<String> targets;

    public static void addExportsService(Map<String, List<ModuleQualifiedExportsService>> qualifiedExports, ModuleQualifiedExportsService exportsService, String moduleName) {
        for (String targetName : exportsService.getTargets()) {
            logger.debug("Registered qualified export from module " + moduleName + " to " + targetName);
            qualifiedExports.computeIfAbsent(targetName, k -> new ArrayList()).add(exportsService);
        }
    }

    public static void exposeQualifiedExportsAndOpens(Module target, Map<String, List<ModuleQualifiedExportsService>> qualifiedExports) {
        qualifiedExports.getOrDefault(target.getName(), List.of()).forEach(exportService -> exportService.addExportsAndOpens(target));
    }

    public static Map<String, List<ModuleQualifiedExportsService>> getBootServices() {
        return Holder.exportsServices;
    }

    protected ModuleQualifiedExportsService() {
        this(null);
    }

    protected ModuleQualifiedExportsService(Module module) {
        this.module = module == null ? this.getClass().getModule() : module;
        this.qualifiedExports = ModuleQualifiedExportsService.invert(this.module.getDescriptor().exports(), ModuleDescriptor.Exports::isQualified, ModuleDescriptor.Exports::source, ModuleDescriptor.Exports::targets);
        this.qualifiedOpens = ModuleQualifiedExportsService.invert(this.module.getDescriptor().opens(), ModuleDescriptor.Opens::isQualified, ModuleDescriptor.Opens::source, ModuleDescriptor.Opens::targets);
        this.targets = Stream.concat(this.qualifiedExports.keySet().stream(), this.qualifiedOpens.keySet().stream()).collect(Collectors.toUnmodifiableSet());
    }

    private static <T> Map<String, List<String>> invert(Collection<T> sourcesToTargets, Predicate<T> qualifiedPredicate, Function<T, String> sourceGetter, Function<T, Collection<String>> targetsGetter) {
        HashMap<String, List> targetsToSources = new HashMap<String, List>();
        for (T sourceToTargets : sourcesToTargets) {
            if (!qualifiedPredicate.test(sourceToTargets)) continue;
            String source = sourceGetter.apply(sourceToTargets);
            Collection<String> targets = targetsGetter.apply(sourceToTargets);
            for (String target : targets) {
                targetsToSources.computeIfAbsent(target, k -> new ArrayList()).add(source);
            }
        }
        targetsToSources.replaceAll((k, v) -> List.copyOf(v));
        return Map.copyOf(targetsToSources);
    }

    public Set<String> getTargets() {
        return this.targets;
    }

    public void addExportsAndOpens(Module target) {
        String targetName = target.getName();
        if (!this.targets.contains(targetName)) {
            throw new IllegalArgumentException("Module " + this.module.getName() + " does not contain qualified exports or opens for module " + targetName);
        }
        List exports = this.qualifiedExports.getOrDefault(targetName, List.of());
        for (String export : exports) {
            this.addExports(export, target);
        }
        List opens = this.qualifiedOpens.getOrDefault(targetName, List.of());
        for (String open : opens) {
            this.addOpens(open, target);
        }
    }

    protected abstract void addExports(String var1, Module var2);

    protected abstract void addOpens(String var1, Module var2);

    private static class Holder {
        private static final Map<String, List<ModuleQualifiedExportsService>> exportsServices;

        private Holder() {
        }

        static {
            HashMap<String, List<ModuleQualifiedExportsService>> qualifiedExports = new HashMap<String, List<ModuleQualifiedExportsService>>();
            ServiceLoader<ModuleQualifiedExportsService> loader = ServiceLoader.load(ModuleQualifiedExportsService.class, ModuleQualifiedExportsService.class.getClassLoader());
            for (ModuleQualifiedExportsService exportsService : loader) {
                ModuleQualifiedExportsService.addExportsService(qualifiedExports, exportsService, exportsService.getClass().getModule().getName());
            }
            exportsServices = Map.copyOf(qualifiedExports);
        }
    }
}

