/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.writeloadforecaster;

import java.util.Collection;
import java.util.List;
import org.elasticsearch.cluster.routing.allocation.WriteLoadForecaster;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicensedFeature;
import org.elasticsearch.plugins.ClusterPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.writeloadforecaster.LicensedWriteLoadForecaster;

public class WriteLoadForecasterPlugin
extends Plugin
implements ClusterPlugin {
    public static final LicensedFeature.Momentary WRITE_LOAD_FORECAST_FEATURE = LicensedFeature.momentary(null, (String)"write-load-forecast", (License.OperationMode)License.OperationMode.ENTERPRISE);
    public static final Setting<Double> OVERRIDE_WRITE_LOAD_FORECAST_SETTING = Setting.doubleSetting((String)"index.override_write_load_forecast", (double)0.0, (double)0.0, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.IndexScope});

    protected boolean hasValidLicense() {
        return WRITE_LOAD_FORECAST_FEATURE.check(XPackPlugin.getSharedLicenseState());
    }

    public List<Setting<?>> getSettings() {
        return List.of(LicensedWriteLoadForecaster.MAX_INDEX_AGE_SETTING, OVERRIDE_WRITE_LOAD_FORECAST_SETTING);
    }

    public Collection<WriteLoadForecaster> createWriteLoadForecasters(ThreadPool threadPool, Settings settings, ClusterSettings clusterSettings) {
        return List.of(new LicensedWriteLoadForecaster(this::hasValidLicense, threadPool, settings, clusterSettings));
    }
}

