/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.application.connector.action.ConnectorActionRequest;
import org.elasticsearch.xpack.application.connector.action.ConnectorCreateActionResponse;

public class PutConnectorAction {
    public static final String NAME = "cluster:admin/xpack/connector/put";
    public static final ActionType<ConnectorCreateActionResponse> INSTANCE = new ActionType("cluster:admin/xpack/connector/put");

    private PutConnectorAction() {
    }

    public static class Request
    extends ConnectorActionRequest
    implements ToXContentObject {
        @Nullable
        private final String connectorId;
        @Nullable
        private final String description;
        @Nullable
        private final String indexName;
        @Nullable
        private final Boolean isNative;
        @Nullable
        private final String language;
        @Nullable
        private final String name;
        @Nullable
        private final String serviceType;
        private static final ConstructingObjectParser<Request, String> PARSER = new ConstructingObjectParser("connector_put_request", false, (args, connectorId) -> new Request((String)connectorId, (String)args[0], (String)args[1], (Boolean)args[2], (String)args[3], (String)args[4], (String)args[5]));

        public Request(String connectorId, String description, String indexName, Boolean isNative, String language, String name, String serviceType) {
            this.connectorId = connectorId;
            this.description = description;
            this.indexName = indexName;
            this.isNative = isNative;
            this.language = language;
            this.name = name;
            this.serviceType = serviceType;
        }

        public Request(String connectorId) {
            this(connectorId, null, null, false, null, null, null);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.connectorId = in.readString();
            this.description = in.readOptionalString();
            this.indexName = in.readOptionalString();
            this.isNative = in.readOptionalBoolean();
            this.language = in.readOptionalString();
            this.name = in.readOptionalString();
            this.serviceType = in.readOptionalString();
        }

        public boolean isConnectorIdNullOrEmpty() {
            return Strings.isNullOrEmpty((String)this.connectorId);
        }

        public static Request fromXContent(XContentParser parser, String connectorId) throws IOException {
            return (Request)((Object)PARSER.parse(parser, (Object)connectorId));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.description != null) {
                builder.field("description", this.description);
            }
            if (this.indexName != null) {
                builder.field("index_name", this.indexName);
            }
            if (this.isNative != null) {
                builder.field("is_native", this.isNative);
            }
            if (this.language != null) {
                builder.field("language", this.language);
            }
            if (this.name != null) {
                builder.field("name", this.name);
            }
            if (this.serviceType != null) {
                builder.field("service_type", this.serviceType);
            }
            builder.endObject();
            return builder;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            validationException = this.validateIndexName(this.indexName, validationException);
            if (Boolean.TRUE.equals(this.isNative)) {
                validationException = this.validateManagedConnectorIndexPrefix(this.indexName, validationException);
            }
            return validationException;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.connectorId);
            out.writeOptionalString(this.description);
            out.writeOptionalString(this.indexName);
            out.writeOptionalBoolean(this.isNative);
            out.writeOptionalString(this.language);
            out.writeOptionalString(this.name);
            out.writeOptionalString(this.serviceType);
        }

        public String getConnectorId() {
            return this.connectorId;
        }

        public String getDescription() {
            return this.description;
        }

        public String getIndexName() {
            return this.indexName;
        }

        public Boolean getIsNative() {
            return this.isNative;
        }

        public String getLanguage() {
            return this.language;
        }

        public String getName() {
            return this.name;
        }

        public String getServiceType() {
            return this.serviceType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.connectorId, request.connectorId) && Objects.equals(this.description, request.description) && Objects.equals(this.indexName, request.indexName) && Objects.equals(this.isNative, request.isNative) && Objects.equals(this.language, request.language) && Objects.equals(this.name, request.name) && Objects.equals(this.serviceType, request.serviceType);
        }

        public int hashCode() {
            return Objects.hash(this.connectorId, this.description, this.indexName, this.isNative, this.language, this.name, this.serviceType);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("description", new String[0]));
            PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), new ParseField("index_name", new String[0]));
            PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), new ParseField("is_native", new String[0]));
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("language", new String[0]));
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("name", new String[0]));
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("service_type", new String[0]));
        }
    }
}

