/*
** Copyright (C) 2001-2004 Andrew R. Baker <andrewb@snort.org>
**
** This program is distributed under the terms of version 1.0 of the 
** Q Public License.  See LICENSE.QPL for further details.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
*/

#ifndef __PROG_VARS_H__
#define __PROG_VARS_H__

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <sys/types.h>
#include <stdio.h>

#include "CommandLineArgs.h"

#define MODE_CONTINUAL  0
#define MODE_BATCH      1

typedef struct _ProgVars
{
    char *config_file;
    char *config_dir;
    u_int8_t run_mode;  
    
    /* General variables */
    char *class_file;
    char *sid_msg_file;
    char *gen_msg_file;
    char *hostname;
    char *interface;
    char *bpf_filter;
    char *log_dir;
    u_int8_t start_at_end;
    u_int8_t verbose;
    u_int8_t localtime;
    
    /* Batch mode options */
    char **filelist;

    /* Continual mode options */
    char *spool_dir;
    char *spool_file;
    char *pid_file;
    char *archive_dir;
    char *waldo_file;
    u_int32_t record_number;
    time_t timet;
    u_int8_t daemon_flag;
    

    /* Runtime parameters */
    u_int8_t stop;
    u_int8_t exit;
    u_int8_t reload;
    
} ProgVars;

int ProgVars_Populate(CommandLineArgs *clargs, ProgVars *prog_vars);
int ProgVars_Fprintf(ProgVars *prog_vars, FILE *stream);
int ProgVars_Free(ProgVars *prog_vars);

#endif  /* __PROG_VARS_H__ */
