/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1 "k8s.io/api/rbac/v1"
	rbacv1 "k8s.io/client-go/applyconfigurations/rbac/v1"
	gentype "k8s.io/client-go/gentype"
	typedrbacv1 "k8s.io/client-go/kubernetes/typed/rbac/v1"
)

// fakeClusterRoleBindings implements ClusterRoleBindingInterface
type fakeClusterRoleBindings struct {
	*gentype.FakeClientWithListAndApply[*v1.ClusterRoleBinding, *v1.ClusterRoleBindingList, *rbacv1.ClusterRoleBindingApplyConfiguration]
	Fake *FakeRbacV1
}

func newFakeClusterRoleBindings(fake *FakeRbacV1) typedrbacv1.ClusterRoleBindingInterface {
	return &fakeClusterRoleBindings{
		gentype.NewFakeClientWithListAndApply[*v1.ClusterRoleBinding, *v1.ClusterRoleBindingList, *rbacv1.ClusterRoleBindingApplyConfiguration](
			fake.Fake,
			"",
			v1.SchemeGroupVersion.WithResource("clusterrolebindings"),
			v1.SchemeGroupVersion.WithKind("ClusterRoleBinding"),
			func() *v1.ClusterRoleBinding { return &v1.ClusterRoleBinding{} },
			func() *v1.ClusterRoleBindingList { return &v1.ClusterRoleBindingList{} },
			func(dst, src *v1.ClusterRoleBindingList) { dst.ListMeta = src.ListMeta },
			func(list *v1.ClusterRoleBindingList) []*v1.ClusterRoleBinding {
				return gentype.ToPointerSlice(list.Items)
			},
			func(list *v1.ClusterRoleBindingList, items []*v1.ClusterRoleBinding) {
				list.Items = gentype.FromPointerSlice(items)
			},
		),
		fake,
	}
}
