/*
 * Decompiled with CFR 0.152.
 */
package org.hampelratte.svdrp.responses.highlevel;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import org.hampelratte.svdrp.responses.highlevel.EPGEntry;
import org.hampelratte.svdrp.responses.highlevel.TreeNode;

public class Recording
extends EPGEntry
implements Comparable<Recording>,
TreeNode {
    private static final long serialVersionUID = 2L;
    private int number;
    private boolean isNew = false;
    private String display;
    private String folder;
    private int priority = 0;
    private int lifetime = 0;
    private int duration = 0;

    public Recording() {
    }

    public Recording(EPGEntry entry) {
        this.copyFrom(entry);
    }

    public void copyFrom(EPGEntry entry) {
        super.setChannelID(entry.getChannelID());
        super.setChannelName(entry.getChannelName());
        super.setDescription(entry.getDescription());
        super.setEndTime(entry.getEndTime());
        super.setEventID(entry.getEventID());
        super.setShortText(entry.getShortText());
        super.setStartTime(entry.getStartTime());
        super.setStreams(entry.getStreams());
        super.setTableID(entry.getTableID());
        this.display = entry.getTitle();
        super.setVersion(entry.getVersion());
        super.setVpsTime(entry.getVpsTime());
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public void setStartTime(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(date.getTime());
        this.setStartTime(cal);
    }

    @Override
    public String getDisplayTitle() {
        if (this.display == null) {
            this.display = this.getTitle();
            if (this.display.contains("~")) {
                this.display = this.display.endsWith("~") ? this.display.substring(0, this.display.length() - 1) : this.display.substring(this.display.lastIndexOf(126) + 1);
            }
            while (this.display.charAt(0) == '%') {
                this.display = this.display.substring(1);
            }
        }
        return this.display;
    }

    public String getFolder() {
        if (this.folder == null && this.getTitle().contains("~")) {
            this.folder = this.getTitle().substring(0, this.getTitle().lastIndexOf(126));
            while (this.folder.charAt(0) == '%') {
                this.folder = this.folder.substring(1);
            }
            this.folder = this.folder.replaceAll("~%", "/");
            this.folder = this.folder.replaceAll("~", "/");
        }
        return this.folder;
    }

    public void setDisplayTitle(String display) {
        this.display = display;
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
        this.display = null;
        this.folder = null;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public boolean isCut() {
        return this.getTitle().startsWith("%") || this.getTitle().contains("~%");
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(int lifetime) {
        this.lifetime = lifetime;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    @Override
    public String toString() {
        return this.getNumber() + " " + DateFormat.getDateTimeInstance().format(this.getStartTime().getTime()) + (this.isNew() ? "*" : "") + " " + super.toString();
    }

    @Override
    public int compareTo(Recording other) {
        return this.getTitle().compareTo(other.getTitle());
    }
}

