/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
export const SVG_NAMESPACE = 'svg';
export const SVG_NAMESPACE_URI = 'http://www.w3.org/2000/svg';
export const MATH_ML_NAMESPACE = 'math';
export const MATH_ML_NAMESPACE_URI = 'http://www.w3.org/1998/MathML/';
export function getNamespaceUri(namespace) {
    const name = namespace.toLowerCase();
    return name === SVG_NAMESPACE ? SVG_NAMESPACE_URI :
        (name === MATH_ML_NAMESPACE ? MATH_ML_NAMESPACE_URI : null);
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmFtZXNwYWNlcy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uLy4uL3BhY2thZ2VzL2NvcmUvc3JjL3JlbmRlcjMvbmFtZXNwYWNlcy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTs7Ozs7O0dBTUc7QUFFSCxNQUFNLENBQUMsTUFBTSxhQUFhLEdBQUcsS0FBSyxDQUFDO0FBQ25DLE1BQU0sQ0FBQyxNQUFNLGlCQUFpQixHQUFHLDRCQUE0QixDQUFDO0FBQzlELE1BQU0sQ0FBQyxNQUFNLGlCQUFpQixHQUFHLE1BQU0sQ0FBQztBQUN4QyxNQUFNLENBQUMsTUFBTSxxQkFBcUIsR0FBRyxnQ0FBZ0MsQ0FBQztBQUV0RSxNQUFNLFVBQVUsZUFBZSxDQUFDLFNBQWlCO0lBQy9DLE1BQU0sSUFBSSxHQUFHLFNBQVMsQ0FBQyxXQUFXLEVBQUUsQ0FBQztJQUNyQyxPQUFPLElBQUksS0FBSyxhQUFhLENBQUMsQ0FBQyxDQUFDLGlCQUFpQixDQUFDLENBQUM7UUFDbkIsQ0FBQyxJQUFJLEtBQUssaUJBQWlCLENBQUMsQ0FBQyxDQUFDLHFCQUFxQixDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsQ0FBQztBQUM5RixDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBAbGljZW5zZVxuICogQ29weXJpZ2h0IEdvb2dsZSBMTEMgQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiBVc2Ugb2YgdGhpcyBzb3VyY2UgY29kZSBpcyBnb3Zlcm5lZCBieSBhbiBNSVQtc3R5bGUgbGljZW5zZSB0aGF0IGNhbiBiZVxuICogZm91bmQgaW4gdGhlIExJQ0VOU0UgZmlsZSBhdCBodHRwczovL2FuZ3VsYXIuaW8vbGljZW5zZVxuICovXG5cbmV4cG9ydCBjb25zdCBTVkdfTkFNRVNQQUNFID0gJ3N2Zyc7XG5leHBvcnQgY29uc3QgU1ZHX05BTUVTUEFDRV9VUkkgPSAnaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmcnO1xuZXhwb3J0IGNvbnN0IE1BVEhfTUxfTkFNRVNQQUNFID0gJ21hdGgnO1xuZXhwb3J0IGNvbnN0IE1BVEhfTUxfTkFNRVNQQUNFX1VSSSA9ICdodHRwOi8vd3d3LnczLm9yZy8xOTk4L01hdGhNTC8nO1xuXG5leHBvcnQgZnVuY3Rpb24gZ2V0TmFtZXNwYWNlVXJpKG5hbWVzcGFjZTogc3RyaW5nKTogc3RyaW5nfG51bGwge1xuICBjb25zdCBuYW1lID0gbmFtZXNwYWNlLnRvTG93ZXJDYXNlKCk7XG4gIHJldHVybiBuYW1lID09PSBTVkdfTkFNRVNQQUNFID8gU1ZHX05BTUVTUEFDRV9VUkkgOlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIChuYW1lID09PSBNQVRIX01MX05BTUVTUEFDRSA/IE1BVEhfTUxfTkFNRVNQQUNFX1VSSSA6IG51bGwpO1xufVxuIl19