// Copyright 2021-2024 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
import { codegenInfo } from "@bufbuild/protobuf";
import { createJsDocBlock as createJsDocBlockInternal } from "./jsdoc.js";
export { reifyWkt } from "./reify-wkt.js";
export { createImportSymbol } from "./import-symbol.js";
export const { localName } = codegenInfo;
export { getFieldExplicitDefaultValue, getFieldIntrinsicDefaultValue, getFieldTyping, literalString, } from "./legacy-gencommon.js";
export { findCustomScalarOption, findCustomMessageOption, findCustomEnumOption, } from "./legacy-custom-options.js";
/**
 * @deprecated Please use GeneratedFile.jsDoc() instead
 */
export function makeJsDoc(desc, indentation = "") {
    return createJsDocBlockInternal(desc, indentation).toString();
}
/**
 * @deprecated Please use GeneratedFile.jsDoc() instead
 */
export function createJsDocBlock(text, indentation = "") {
    return createJsDocBlockInternal(text, indentation).toString();
}
