// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: BUSL-1.1

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        (unknown)
// source: private/pbservice/healthcheck.proto

package pbservice

import (
	pbcommon "github.com/hashicorp/consul/proto/private/pbcommon"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// HealthCheck represents a single check on a given node
//
// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.HealthCheck
// output=healthcheck.gen.go
// name=Structs
type HealthCheck struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	Node  string                 `protobuf:"bytes,1,opt,name=Node,proto3" json:"Node,omitempty"`
	// mog: func-to=CheckIDType func-from=string
	CheckID     string                 `protobuf:"bytes,2,opt,name=CheckID,proto3" json:"CheckID,omitempty"`
	Name        string                 `protobuf:"bytes,3,opt,name=Name,proto3" json:"Name,omitempty"`
	Status      string                 `protobuf:"bytes,4,opt,name=Status,proto3" json:"Status,omitempty"`           // The current check status
	Notes       string                 `protobuf:"bytes,5,opt,name=Notes,proto3" json:"Notes,omitempty"`             // Additional notes with the status
	Output      string                 `protobuf:"bytes,6,opt,name=Output,proto3" json:"Output,omitempty"`           // Holds output of script runs
	ServiceID   string                 `protobuf:"bytes,7,opt,name=ServiceID,proto3" json:"ServiceID,omitempty"`     // optional associated service
	ServiceName string                 `protobuf:"bytes,8,opt,name=ServiceName,proto3" json:"ServiceName,omitempty"` // optional service name
	ServiceTags []string               `protobuf:"bytes,9,rep,name=ServiceTags,proto3" json:"ServiceTags,omitempty"` // optional service tags
	Type        string                 `protobuf:"bytes,12,opt,name=Type,proto3" json:"Type,omitempty"`              // Check type: http/ttl/tcp/etc
	Definition  *HealthCheckDefinition `protobuf:"bytes,10,opt,name=Definition,proto3" json:"Definition,omitempty"`
	// mog: func-to=RaftIndexToStructs func-from=NewRaftIndexFromStructs
	RaftIndex *pbcommon.RaftIndex `protobuf:"bytes,11,opt,name=RaftIndex,proto3" json:"RaftIndex,omitempty"`
	// mog: func-to=EnterpriseMetaToStructs func-from=NewEnterpriseMetaFromStructs
	EnterpriseMeta *pbcommon.EnterpriseMeta `protobuf:"bytes,13,opt,name=EnterpriseMeta,proto3" json:"EnterpriseMeta,omitempty"`
	// mog: func-to=int func-from=int32
	ExposedPort   int32  `protobuf:"varint,14,opt,name=ExposedPort,proto3" json:"ExposedPort,omitempty"`
	Interval      string `protobuf:"bytes,15,opt,name=Interval,proto3" json:"Interval,omitempty"`
	Timeout       string `protobuf:"bytes,16,opt,name=Timeout,proto3" json:"Timeout,omitempty"`
	PeerName      string `protobuf:"bytes,17,opt,name=PeerName,proto3" json:"PeerName,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HealthCheck) Reset() {
	*x = HealthCheck{}
	mi := &file_private_pbservice_healthcheck_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HealthCheck) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HealthCheck) ProtoMessage() {}

func (x *HealthCheck) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbservice_healthcheck_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HealthCheck.ProtoReflect.Descriptor instead.
func (*HealthCheck) Descriptor() ([]byte, []int) {
	return file_private_pbservice_healthcheck_proto_rawDescGZIP(), []int{0}
}

func (x *HealthCheck) GetNode() string {
	if x != nil {
		return x.Node
	}
	return ""
}

func (x *HealthCheck) GetCheckID() string {
	if x != nil {
		return x.CheckID
	}
	return ""
}

func (x *HealthCheck) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *HealthCheck) GetStatus() string {
	if x != nil {
		return x.Status
	}
	return ""
}

func (x *HealthCheck) GetNotes() string {
	if x != nil {
		return x.Notes
	}
	return ""
}

func (x *HealthCheck) GetOutput() string {
	if x != nil {
		return x.Output
	}
	return ""
}

func (x *HealthCheck) GetServiceID() string {
	if x != nil {
		return x.ServiceID
	}
	return ""
}

func (x *HealthCheck) GetServiceName() string {
	if x != nil {
		return x.ServiceName
	}
	return ""
}

func (x *HealthCheck) GetServiceTags() []string {
	if x != nil {
		return x.ServiceTags
	}
	return nil
}

func (x *HealthCheck) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *HealthCheck) GetDefinition() *HealthCheckDefinition {
	if x != nil {
		return x.Definition
	}
	return nil
}

func (x *HealthCheck) GetRaftIndex() *pbcommon.RaftIndex {
	if x != nil {
		return x.RaftIndex
	}
	return nil
}

func (x *HealthCheck) GetEnterpriseMeta() *pbcommon.EnterpriseMeta {
	if x != nil {
		return x.EnterpriseMeta
	}
	return nil
}

func (x *HealthCheck) GetExposedPort() int32 {
	if x != nil {
		return x.ExposedPort
	}
	return 0
}

func (x *HealthCheck) GetInterval() string {
	if x != nil {
		return x.Interval
	}
	return ""
}

func (x *HealthCheck) GetTimeout() string {
	if x != nil {
		return x.Timeout
	}
	return ""
}

func (x *HealthCheck) GetPeerName() string {
	if x != nil {
		return x.PeerName
	}
	return ""
}

type HeaderValue struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Value         []string               `protobuf:"bytes,1,rep,name=Value,proto3" json:"Value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HeaderValue) Reset() {
	*x = HeaderValue{}
	mi := &file_private_pbservice_healthcheck_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HeaderValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HeaderValue) ProtoMessage() {}

func (x *HeaderValue) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbservice_healthcheck_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HeaderValue.ProtoReflect.Descriptor instead.
func (*HeaderValue) Descriptor() ([]byte, []int) {
	return file_private_pbservice_healthcheck_proto_rawDescGZIP(), []int{1}
}

func (x *HeaderValue) GetValue() []string {
	if x != nil {
		return x.Value
	}
	return nil
}

// HealthCheckDefinition of a single HealthCheck.
//
// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.HealthCheckDefinition
// output=healthcheck.gen.go
// name=Structs
type HealthCheckDefinition struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	HTTP          string                 `protobuf:"bytes,1,opt,name=HTTP,proto3" json:"HTTP,omitempty"`
	TLSServerName string                 `protobuf:"bytes,19,opt,name=TLSServerName,proto3" json:"TLSServerName,omitempty"`
	TLSSkipVerify bool                   `protobuf:"varint,2,opt,name=TLSSkipVerify,proto3" json:"TLSSkipVerify,omitempty"`
	// mog: func-to=MapHeadersToStructs func-from=NewMapHeadersFromStructs
	Header           map[string]*HeaderValue `protobuf:"bytes,3,rep,name=Header,proto3" json:"Header,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	Method           string                  `protobuf:"bytes,4,opt,name=Method,proto3" json:"Method,omitempty"`
	Body             string                  `protobuf:"bytes,18,opt,name=Body,proto3" json:"Body,omitempty"`
	DisableRedirects bool                    `protobuf:"varint,22,opt,name=DisableRedirects,proto3" json:"DisableRedirects,omitempty"`
	TCP              string                  `protobuf:"bytes,5,opt,name=TCP,proto3" json:"TCP,omitempty"`
	TCPUseTLS        bool                    `protobuf:"varint,25,opt,name=TCPUseTLS,proto3" json:"TCPUseTLS,omitempty"`
	UDP              string                  `protobuf:"bytes,23,opt,name=UDP,proto3" json:"UDP,omitempty"`
	OSService        string                  `protobuf:"bytes,24,opt,name=OSService,proto3" json:"OSService,omitempty"`
	// mog: func-to=structs.DurationFromProto func-from=structs.DurationToProto
	Interval *durationpb.Duration `protobuf:"bytes,6,opt,name=Interval,proto3" json:"Interval,omitempty"`
	// mog: func-to=uint func-from=uint32
	OutputMaxSize uint32 `protobuf:"varint,9,opt,name=OutputMaxSize,proto3" json:"OutputMaxSize,omitempty"`
	// mog: func-to=structs.DurationFromProto func-from=structs.DurationToProto
	Timeout *durationpb.Duration `protobuf:"bytes,7,opt,name=Timeout,proto3" json:"Timeout,omitempty"`
	// mog: func-to=structs.DurationFromProto func-from=structs.DurationToProto
	DeregisterCriticalServiceAfter *durationpb.Duration `protobuf:"bytes,8,opt,name=DeregisterCriticalServiceAfter,proto3" json:"DeregisterCriticalServiceAfter,omitempty"`
	ScriptArgs                     []string             `protobuf:"bytes,10,rep,name=ScriptArgs,proto3" json:"ScriptArgs,omitempty"`
	DockerContainerID              string               `protobuf:"bytes,11,opt,name=DockerContainerID,proto3" json:"DockerContainerID,omitempty"`
	Shell                          string               `protobuf:"bytes,12,opt,name=Shell,proto3" json:"Shell,omitempty"`
	H2PING                         string               `protobuf:"bytes,20,opt,name=H2PING,proto3" json:"H2PING,omitempty"`
	H2PingUseTLS                   bool                 `protobuf:"varint,21,opt,name=H2PingUseTLS,proto3" json:"H2PingUseTLS,omitempty"`
	GRPC                           string               `protobuf:"bytes,13,opt,name=GRPC,proto3" json:"GRPC,omitempty"`
	GRPCUseTLS                     bool                 `protobuf:"varint,14,opt,name=GRPCUseTLS,proto3" json:"GRPCUseTLS,omitempty"`
	AliasNode                      string               `protobuf:"bytes,15,opt,name=AliasNode,proto3" json:"AliasNode,omitempty"`
	AliasService                   string               `protobuf:"bytes,16,opt,name=AliasService,proto3" json:"AliasService,omitempty"`
	// mog: func-to=structs.DurationFromProto func-from=structs.DurationToProto
	TTL           *durationpb.Duration `protobuf:"bytes,17,opt,name=TTL,proto3" json:"TTL,omitempty"`
	SessionName   string               `protobuf:"bytes,26,opt,name=SessionName,proto3" json:"SessionName,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HealthCheckDefinition) Reset() {
	*x = HealthCheckDefinition{}
	mi := &file_private_pbservice_healthcheck_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HealthCheckDefinition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HealthCheckDefinition) ProtoMessage() {}

func (x *HealthCheckDefinition) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbservice_healthcheck_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HealthCheckDefinition.ProtoReflect.Descriptor instead.
func (*HealthCheckDefinition) Descriptor() ([]byte, []int) {
	return file_private_pbservice_healthcheck_proto_rawDescGZIP(), []int{2}
}

func (x *HealthCheckDefinition) GetHTTP() string {
	if x != nil {
		return x.HTTP
	}
	return ""
}

func (x *HealthCheckDefinition) GetTLSServerName() string {
	if x != nil {
		return x.TLSServerName
	}
	return ""
}

func (x *HealthCheckDefinition) GetTLSSkipVerify() bool {
	if x != nil {
		return x.TLSSkipVerify
	}
	return false
}

func (x *HealthCheckDefinition) GetHeader() map[string]*HeaderValue {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *HealthCheckDefinition) GetMethod() string {
	if x != nil {
		return x.Method
	}
	return ""
}

func (x *HealthCheckDefinition) GetBody() string {
	if x != nil {
		return x.Body
	}
	return ""
}

func (x *HealthCheckDefinition) GetDisableRedirects() bool {
	if x != nil {
		return x.DisableRedirects
	}
	return false
}

func (x *HealthCheckDefinition) GetTCP() string {
	if x != nil {
		return x.TCP
	}
	return ""
}

func (x *HealthCheckDefinition) GetTCPUseTLS() bool {
	if x != nil {
		return x.TCPUseTLS
	}
	return false
}

func (x *HealthCheckDefinition) GetUDP() string {
	if x != nil {
		return x.UDP
	}
	return ""
}

func (x *HealthCheckDefinition) GetOSService() string {
	if x != nil {
		return x.OSService
	}
	return ""
}

func (x *HealthCheckDefinition) GetInterval() *durationpb.Duration {
	if x != nil {
		return x.Interval
	}
	return nil
}

func (x *HealthCheckDefinition) GetOutputMaxSize() uint32 {
	if x != nil {
		return x.OutputMaxSize
	}
	return 0
}

func (x *HealthCheckDefinition) GetTimeout() *durationpb.Duration {
	if x != nil {
		return x.Timeout
	}
	return nil
}

func (x *HealthCheckDefinition) GetDeregisterCriticalServiceAfter() *durationpb.Duration {
	if x != nil {
		return x.DeregisterCriticalServiceAfter
	}
	return nil
}

func (x *HealthCheckDefinition) GetScriptArgs() []string {
	if x != nil {
		return x.ScriptArgs
	}
	return nil
}

func (x *HealthCheckDefinition) GetDockerContainerID() string {
	if x != nil {
		return x.DockerContainerID
	}
	return ""
}

func (x *HealthCheckDefinition) GetShell() string {
	if x != nil {
		return x.Shell
	}
	return ""
}

func (x *HealthCheckDefinition) GetH2PING() string {
	if x != nil {
		return x.H2PING
	}
	return ""
}

func (x *HealthCheckDefinition) GetH2PingUseTLS() bool {
	if x != nil {
		return x.H2PingUseTLS
	}
	return false
}

func (x *HealthCheckDefinition) GetGRPC() string {
	if x != nil {
		return x.GRPC
	}
	return ""
}

func (x *HealthCheckDefinition) GetGRPCUseTLS() bool {
	if x != nil {
		return x.GRPCUseTLS
	}
	return false
}

func (x *HealthCheckDefinition) GetAliasNode() string {
	if x != nil {
		return x.AliasNode
	}
	return ""
}

func (x *HealthCheckDefinition) GetAliasService() string {
	if x != nil {
		return x.AliasService
	}
	return ""
}

func (x *HealthCheckDefinition) GetTTL() *durationpb.Duration {
	if x != nil {
		return x.TTL
	}
	return nil
}

func (x *HealthCheckDefinition) GetSessionName() string {
	if x != nil {
		return x.SessionName
	}
	return ""
}

// CheckType is used to create either the CheckMonitor or the CheckTTL.
// The following types are supported: Script, HTTP, TCP, Docker, TTL, GRPC,
// Alias. Script, H2PING,
// HTTP, Docker, TCP, H2PING and GRPC all require Interval. Only one of the types may
// to be provided: TTL or Script/Interval or HTTP/Interval or TCP/Interval or
// Docker/Interval or GRPC/Interval or H2PING/Interval or AliasService.
//
// mog annotation:
//
// target=github.com/hashicorp/consul/agent/structs.CheckType
// output=healthcheck.gen.go
// name=Structs
type CheckType struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// mog: func-to=CheckIDType func-from=string
	CheckID    string   `protobuf:"bytes,1,opt,name=CheckID,proto3" json:"CheckID,omitempty"`
	Name       string   `protobuf:"bytes,2,opt,name=Name,proto3" json:"Name,omitempty"`
	Status     string   `protobuf:"bytes,3,opt,name=Status,proto3" json:"Status,omitempty"`
	Notes      string   `protobuf:"bytes,4,opt,name=Notes,proto3" json:"Notes,omitempty"`
	ScriptArgs []string `protobuf:"bytes,5,rep,name=ScriptArgs,proto3" json:"ScriptArgs,omitempty"`
	HTTP       string   `protobuf:"bytes,6,opt,name=HTTP,proto3" json:"HTTP,omitempty"`
	// mog: func-to=MapHeadersToStructs func-from=NewMapHeadersFromStructs
	Header           map[string]*HeaderValue `protobuf:"bytes,20,rep,name=Header,proto3" json:"Header,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	Method           string                  `protobuf:"bytes,7,opt,name=Method,proto3" json:"Method,omitempty"`
	Body             string                  `protobuf:"bytes,26,opt,name=Body,proto3" json:"Body,omitempty"`
	DisableRedirects bool                    `protobuf:"varint,31,opt,name=DisableRedirects,proto3" json:"DisableRedirects,omitempty"`
	TCP              string                  `protobuf:"bytes,8,opt,name=TCP,proto3" json:"TCP,omitempty"`
	TCPUseTLS        bool                    `protobuf:"varint,34,opt,name=TCPUseTLS,proto3" json:"TCPUseTLS,omitempty"`
	UDP              string                  `protobuf:"bytes,32,opt,name=UDP,proto3" json:"UDP,omitempty"`
	OSService        string                  `protobuf:"bytes,33,opt,name=OSService,proto3" json:"OSService,omitempty"`
	// mog: func-to=structs.DurationFromProto func-from=structs.DurationToProto
	Interval          *durationpb.Duration `protobuf:"bytes,9,opt,name=Interval,proto3" json:"Interval,omitempty"`
	AliasNode         string               `protobuf:"bytes,10,opt,name=AliasNode,proto3" json:"AliasNode,omitempty"`
	AliasService      string               `protobuf:"bytes,11,opt,name=AliasService,proto3" json:"AliasService,omitempty"`
	DockerContainerID string               `protobuf:"bytes,12,opt,name=DockerContainerID,proto3" json:"DockerContainerID,omitempty"`
	Shell             string               `protobuf:"bytes,13,opt,name=Shell,proto3" json:"Shell,omitempty"`
	H2PING            string               `protobuf:"bytes,28,opt,name=H2PING,proto3" json:"H2PING,omitempty"`
	H2PingUseTLS      bool                 `protobuf:"varint,30,opt,name=H2PingUseTLS,proto3" json:"H2PingUseTLS,omitempty"`
	GRPC              string               `protobuf:"bytes,14,opt,name=GRPC,proto3" json:"GRPC,omitempty"`
	GRPCUseTLS        bool                 `protobuf:"varint,15,opt,name=GRPCUseTLS,proto3" json:"GRPCUseTLS,omitempty"`
	TLSServerName     string               `protobuf:"bytes,27,opt,name=TLSServerName,proto3" json:"TLSServerName,omitempty"`
	TLSSkipVerify     bool                 `protobuf:"varint,16,opt,name=TLSSkipVerify,proto3" json:"TLSSkipVerify,omitempty"`
	// mog: func-to=structs.DurationFromProto func-from=structs.DurationToProto
	Timeout *durationpb.Duration `protobuf:"bytes,17,opt,name=Timeout,proto3" json:"Timeout,omitempty"`
	// mog: func-to=structs.DurationFromProto func-from=structs.DurationToProto
	TTL *durationpb.Duration `protobuf:"bytes,18,opt,name=TTL,proto3" json:"TTL,omitempty"`
	// mog: func-to=int func-from=int32
	SuccessBeforePassing int32 `protobuf:"varint,21,opt,name=SuccessBeforePassing,proto3" json:"SuccessBeforePassing,omitempty"`
	// mog: func-to=int func-from=int32
	FailuresBeforeWarning int32 `protobuf:"varint,29,opt,name=FailuresBeforeWarning,proto3" json:"FailuresBeforeWarning,omitempty"`
	// mog: func-to=int func-from=int32
	FailuresBeforeCritical int32 `protobuf:"varint,22,opt,name=FailuresBeforeCritical,proto3" json:"FailuresBeforeCritical,omitempty"`
	// Definition fields used when exposing checks through a proxy
	ProxyHTTP string `protobuf:"bytes,23,opt,name=ProxyHTTP,proto3" json:"ProxyHTTP,omitempty"`
	ProxyGRPC string `protobuf:"bytes,24,opt,name=ProxyGRPC,proto3" json:"ProxyGRPC,omitempty"`
	// DeregisterCriticalServiceAfter, if >0, will cause the associated
	// service, if any, to be deregistered if this check is critical for
	// longer than this duration.
	// mog: func-to=structs.DurationFromProto func-from=structs.DurationToProto
	DeregisterCriticalServiceAfter *durationpb.Duration `protobuf:"bytes,19,opt,name=DeregisterCriticalServiceAfter,proto3" json:"DeregisterCriticalServiceAfter,omitempty"`
	// mog: func-to=int func-from=int32
	OutputMaxSize int32 `protobuf:"varint,25,opt,name=OutputMaxSize,proto3" json:"OutputMaxSize,omitempty"`
	// The session name of the session, which is associated with the common parent node of the session and this check.
	// This association helps in managing the session and its related state of the checks.
	// e.g. if the session is deleted/invalidated the state of this check shall be marked critical.
	SessionName   string `protobuf:"bytes,35,opt,name=SessionName,proto3" json:"SessionName,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CheckType) Reset() {
	*x = CheckType{}
	mi := &file_private_pbservice_healthcheck_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CheckType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckType) ProtoMessage() {}

func (x *CheckType) ProtoReflect() protoreflect.Message {
	mi := &file_private_pbservice_healthcheck_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckType.ProtoReflect.Descriptor instead.
func (*CheckType) Descriptor() ([]byte, []int) {
	return file_private_pbservice_healthcheck_proto_rawDescGZIP(), []int{3}
}

func (x *CheckType) GetCheckID() string {
	if x != nil {
		return x.CheckID
	}
	return ""
}

func (x *CheckType) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CheckType) GetStatus() string {
	if x != nil {
		return x.Status
	}
	return ""
}

func (x *CheckType) GetNotes() string {
	if x != nil {
		return x.Notes
	}
	return ""
}

func (x *CheckType) GetScriptArgs() []string {
	if x != nil {
		return x.ScriptArgs
	}
	return nil
}

func (x *CheckType) GetHTTP() string {
	if x != nil {
		return x.HTTP
	}
	return ""
}

func (x *CheckType) GetHeader() map[string]*HeaderValue {
	if x != nil {
		return x.Header
	}
	return nil
}

func (x *CheckType) GetMethod() string {
	if x != nil {
		return x.Method
	}
	return ""
}

func (x *CheckType) GetBody() string {
	if x != nil {
		return x.Body
	}
	return ""
}

func (x *CheckType) GetDisableRedirects() bool {
	if x != nil {
		return x.DisableRedirects
	}
	return false
}

func (x *CheckType) GetTCP() string {
	if x != nil {
		return x.TCP
	}
	return ""
}

func (x *CheckType) GetTCPUseTLS() bool {
	if x != nil {
		return x.TCPUseTLS
	}
	return false
}

func (x *CheckType) GetUDP() string {
	if x != nil {
		return x.UDP
	}
	return ""
}

func (x *CheckType) GetOSService() string {
	if x != nil {
		return x.OSService
	}
	return ""
}

func (x *CheckType) GetInterval() *durationpb.Duration {
	if x != nil {
		return x.Interval
	}
	return nil
}

func (x *CheckType) GetAliasNode() string {
	if x != nil {
		return x.AliasNode
	}
	return ""
}

func (x *CheckType) GetAliasService() string {
	if x != nil {
		return x.AliasService
	}
	return ""
}

func (x *CheckType) GetDockerContainerID() string {
	if x != nil {
		return x.DockerContainerID
	}
	return ""
}

func (x *CheckType) GetShell() string {
	if x != nil {
		return x.Shell
	}
	return ""
}

func (x *CheckType) GetH2PING() string {
	if x != nil {
		return x.H2PING
	}
	return ""
}

func (x *CheckType) GetH2PingUseTLS() bool {
	if x != nil {
		return x.H2PingUseTLS
	}
	return false
}

func (x *CheckType) GetGRPC() string {
	if x != nil {
		return x.GRPC
	}
	return ""
}

func (x *CheckType) GetGRPCUseTLS() bool {
	if x != nil {
		return x.GRPCUseTLS
	}
	return false
}

func (x *CheckType) GetTLSServerName() string {
	if x != nil {
		return x.TLSServerName
	}
	return ""
}

func (x *CheckType) GetTLSSkipVerify() bool {
	if x != nil {
		return x.TLSSkipVerify
	}
	return false
}

func (x *CheckType) GetTimeout() *durationpb.Duration {
	if x != nil {
		return x.Timeout
	}
	return nil
}

func (x *CheckType) GetTTL() *durationpb.Duration {
	if x != nil {
		return x.TTL
	}
	return nil
}

func (x *CheckType) GetSuccessBeforePassing() int32 {
	if x != nil {
		return x.SuccessBeforePassing
	}
	return 0
}

func (x *CheckType) GetFailuresBeforeWarning() int32 {
	if x != nil {
		return x.FailuresBeforeWarning
	}
	return 0
}

func (x *CheckType) GetFailuresBeforeCritical() int32 {
	if x != nil {
		return x.FailuresBeforeCritical
	}
	return 0
}

func (x *CheckType) GetProxyHTTP() string {
	if x != nil {
		return x.ProxyHTTP
	}
	return ""
}

func (x *CheckType) GetProxyGRPC() string {
	if x != nil {
		return x.ProxyGRPC
	}
	return ""
}

func (x *CheckType) GetDeregisterCriticalServiceAfter() *durationpb.Duration {
	if x != nil {
		return x.DeregisterCriticalServiceAfter
	}
	return nil
}

func (x *CheckType) GetOutputMaxSize() int32 {
	if x != nil {
		return x.OutputMaxSize
	}
	return 0
}

func (x *CheckType) GetSessionName() string {
	if x != nil {
		return x.SessionName
	}
	return ""
}

var File_private_pbservice_healthcheck_proto protoreflect.FileDescriptor

const file_private_pbservice_healthcheck_proto_rawDesc = "" +
	"\n" +
	"#private/pbservice/healthcheck.proto\x12!hashicorp.consul.internal.service\x1a\x1egoogle/protobuf/duration.proto\x1a\x1dprivate/pbcommon/common.proto\"\xfe\x04\n" +
	"\vHealthCheck\x12\x12\n" +
	"\x04Node\x18\x01 \x01(\tR\x04Node\x12\x18\n" +
	"\aCheckID\x18\x02 \x01(\tR\aCheckID\x12\x12\n" +
	"\x04Name\x18\x03 \x01(\tR\x04Name\x12\x16\n" +
	"\x06Status\x18\x04 \x01(\tR\x06Status\x12\x14\n" +
	"\x05Notes\x18\x05 \x01(\tR\x05Notes\x12\x16\n" +
	"\x06Output\x18\x06 \x01(\tR\x06Output\x12\x1c\n" +
	"\tServiceID\x18\a \x01(\tR\tServiceID\x12 \n" +
	"\vServiceName\x18\b \x01(\tR\vServiceName\x12 \n" +
	"\vServiceTags\x18\t \x03(\tR\vServiceTags\x12\x12\n" +
	"\x04Type\x18\f \x01(\tR\x04Type\x12X\n" +
	"\n" +
	"Definition\x18\n" +
	" \x01(\v28.hashicorp.consul.internal.service.HealthCheckDefinitionR\n" +
	"Definition\x12I\n" +
	"\tRaftIndex\x18\v \x01(\v2+.hashicorp.consul.internal.common.RaftIndexR\tRaftIndex\x12X\n" +
	"\x0eEnterpriseMeta\x18\r \x01(\v20.hashicorp.consul.internal.common.EnterpriseMetaR\x0eEnterpriseMeta\x12 \n" +
	"\vExposedPort\x18\x0e \x01(\x05R\vExposedPort\x12\x1a\n" +
	"\bInterval\x18\x0f \x01(\tR\bInterval\x12\x18\n" +
	"\aTimeout\x18\x10 \x01(\tR\aTimeout\x12\x1a\n" +
	"\bPeerName\x18\x11 \x01(\tR\bPeerName\"#\n" +
	"\vHeaderValue\x12\x14\n" +
	"\x05Value\x18\x01 \x03(\tR\x05Value\"\xd2\b\n" +
	"\x15HealthCheckDefinition\x12\x12\n" +
	"\x04HTTP\x18\x01 \x01(\tR\x04HTTP\x12$\n" +
	"\rTLSServerName\x18\x13 \x01(\tR\rTLSServerName\x12$\n" +
	"\rTLSSkipVerify\x18\x02 \x01(\bR\rTLSSkipVerify\x12\\\n" +
	"\x06Header\x18\x03 \x03(\v2D.hashicorp.consul.internal.service.HealthCheckDefinition.HeaderEntryR\x06Header\x12\x16\n" +
	"\x06Method\x18\x04 \x01(\tR\x06Method\x12\x12\n" +
	"\x04Body\x18\x12 \x01(\tR\x04Body\x12*\n" +
	"\x10DisableRedirects\x18\x16 \x01(\bR\x10DisableRedirects\x12\x10\n" +
	"\x03TCP\x18\x05 \x01(\tR\x03TCP\x12\x1c\n" +
	"\tTCPUseTLS\x18\x19 \x01(\bR\tTCPUseTLS\x12\x10\n" +
	"\x03UDP\x18\x17 \x01(\tR\x03UDP\x12\x1c\n" +
	"\tOSService\x18\x18 \x01(\tR\tOSService\x125\n" +
	"\bInterval\x18\x06 \x01(\v2\x19.google.protobuf.DurationR\bInterval\x12$\n" +
	"\rOutputMaxSize\x18\t \x01(\rR\rOutputMaxSize\x123\n" +
	"\aTimeout\x18\a \x01(\v2\x19.google.protobuf.DurationR\aTimeout\x12a\n" +
	"\x1eDeregisterCriticalServiceAfter\x18\b \x01(\v2\x19.google.protobuf.DurationR\x1eDeregisterCriticalServiceAfter\x12\x1e\n" +
	"\n" +
	"ScriptArgs\x18\n" +
	" \x03(\tR\n" +
	"ScriptArgs\x12,\n" +
	"\x11DockerContainerID\x18\v \x01(\tR\x11DockerContainerID\x12\x14\n" +
	"\x05Shell\x18\f \x01(\tR\x05Shell\x12\x16\n" +
	"\x06H2PING\x18\x14 \x01(\tR\x06H2PING\x12\"\n" +
	"\fH2PingUseTLS\x18\x15 \x01(\bR\fH2PingUseTLS\x12\x12\n" +
	"\x04GRPC\x18\r \x01(\tR\x04GRPC\x12\x1e\n" +
	"\n" +
	"GRPCUseTLS\x18\x0e \x01(\bR\n" +
	"GRPCUseTLS\x12\x1c\n" +
	"\tAliasNode\x18\x0f \x01(\tR\tAliasNode\x12\"\n" +
	"\fAliasService\x18\x10 \x01(\tR\fAliasService\x12+\n" +
	"\x03TTL\x18\x11 \x01(\v2\x19.google.protobuf.DurationR\x03TTL\x12 \n" +
	"\vSessionName\x18\x1a \x01(\tR\vSessionName\x1ai\n" +
	"\vHeaderEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12D\n" +
	"\x05value\x18\x02 \x01(\v2..hashicorp.consul.internal.service.HeaderValueR\x05value:\x028\x01\"\xf4\n" +
	"\n" +
	"\tCheckType\x12\x18\n" +
	"\aCheckID\x18\x01 \x01(\tR\aCheckID\x12\x12\n" +
	"\x04Name\x18\x02 \x01(\tR\x04Name\x12\x16\n" +
	"\x06Status\x18\x03 \x01(\tR\x06Status\x12\x14\n" +
	"\x05Notes\x18\x04 \x01(\tR\x05Notes\x12\x1e\n" +
	"\n" +
	"ScriptArgs\x18\x05 \x03(\tR\n" +
	"ScriptArgs\x12\x12\n" +
	"\x04HTTP\x18\x06 \x01(\tR\x04HTTP\x12P\n" +
	"\x06Header\x18\x14 \x03(\v28.hashicorp.consul.internal.service.CheckType.HeaderEntryR\x06Header\x12\x16\n" +
	"\x06Method\x18\a \x01(\tR\x06Method\x12\x12\n" +
	"\x04Body\x18\x1a \x01(\tR\x04Body\x12*\n" +
	"\x10DisableRedirects\x18\x1f \x01(\bR\x10DisableRedirects\x12\x10\n" +
	"\x03TCP\x18\b \x01(\tR\x03TCP\x12\x1c\n" +
	"\tTCPUseTLS\x18\" \x01(\bR\tTCPUseTLS\x12\x10\n" +
	"\x03UDP\x18  \x01(\tR\x03UDP\x12\x1c\n" +
	"\tOSService\x18! \x01(\tR\tOSService\x125\n" +
	"\bInterval\x18\t \x01(\v2\x19.google.protobuf.DurationR\bInterval\x12\x1c\n" +
	"\tAliasNode\x18\n" +
	" \x01(\tR\tAliasNode\x12\"\n" +
	"\fAliasService\x18\v \x01(\tR\fAliasService\x12,\n" +
	"\x11DockerContainerID\x18\f \x01(\tR\x11DockerContainerID\x12\x14\n" +
	"\x05Shell\x18\r \x01(\tR\x05Shell\x12\x16\n" +
	"\x06H2PING\x18\x1c \x01(\tR\x06H2PING\x12\"\n" +
	"\fH2PingUseTLS\x18\x1e \x01(\bR\fH2PingUseTLS\x12\x12\n" +
	"\x04GRPC\x18\x0e \x01(\tR\x04GRPC\x12\x1e\n" +
	"\n" +
	"GRPCUseTLS\x18\x0f \x01(\bR\n" +
	"GRPCUseTLS\x12$\n" +
	"\rTLSServerName\x18\x1b \x01(\tR\rTLSServerName\x12$\n" +
	"\rTLSSkipVerify\x18\x10 \x01(\bR\rTLSSkipVerify\x123\n" +
	"\aTimeout\x18\x11 \x01(\v2\x19.google.protobuf.DurationR\aTimeout\x12+\n" +
	"\x03TTL\x18\x12 \x01(\v2\x19.google.protobuf.DurationR\x03TTL\x122\n" +
	"\x14SuccessBeforePassing\x18\x15 \x01(\x05R\x14SuccessBeforePassing\x124\n" +
	"\x15FailuresBeforeWarning\x18\x1d \x01(\x05R\x15FailuresBeforeWarning\x126\n" +
	"\x16FailuresBeforeCritical\x18\x16 \x01(\x05R\x16FailuresBeforeCritical\x12\x1c\n" +
	"\tProxyHTTP\x18\x17 \x01(\tR\tProxyHTTP\x12\x1c\n" +
	"\tProxyGRPC\x18\x18 \x01(\tR\tProxyGRPC\x12a\n" +
	"\x1eDeregisterCriticalServiceAfter\x18\x13 \x01(\v2\x19.google.protobuf.DurationR\x1eDeregisterCriticalServiceAfter\x12$\n" +
	"\rOutputMaxSize\x18\x19 \x01(\x05R\rOutputMaxSize\x12 \n" +
	"\vSessionName\x18# \x01(\tR\vSessionName\x1ai\n" +
	"\vHeaderEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12D\n" +
	"\x05value\x18\x02 \x01(\v2..hashicorp.consul.internal.service.HeaderValueR\x05value:\x028\x01B\x96\x02\n" +
	"%com.hashicorp.consul.internal.serviceB\x10HealthcheckProtoP\x01Z3github.com/hashicorp/consul/proto/private/pbservice\xa2\x02\x04HCIS\xaa\x02!Hashicorp.Consul.Internal.Service\xca\x02!Hashicorp\\Consul\\Internal\\Service\xe2\x02-Hashicorp\\Consul\\Internal\\Service\\GPBMetadata\xea\x02$Hashicorp::Consul::Internal::Serviceb\x06proto3"

var (
	file_private_pbservice_healthcheck_proto_rawDescOnce sync.Once
	file_private_pbservice_healthcheck_proto_rawDescData []byte
)

func file_private_pbservice_healthcheck_proto_rawDescGZIP() []byte {
	file_private_pbservice_healthcheck_proto_rawDescOnce.Do(func() {
		file_private_pbservice_healthcheck_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_private_pbservice_healthcheck_proto_rawDesc), len(file_private_pbservice_healthcheck_proto_rawDesc)))
	})
	return file_private_pbservice_healthcheck_proto_rawDescData
}

var file_private_pbservice_healthcheck_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_private_pbservice_healthcheck_proto_goTypes = []any{
	(*HealthCheck)(nil),             // 0: hashicorp.consul.internal.service.HealthCheck
	(*HeaderValue)(nil),             // 1: hashicorp.consul.internal.service.HeaderValue
	(*HealthCheckDefinition)(nil),   // 2: hashicorp.consul.internal.service.HealthCheckDefinition
	(*CheckType)(nil),               // 3: hashicorp.consul.internal.service.CheckType
	nil,                             // 4: hashicorp.consul.internal.service.HealthCheckDefinition.HeaderEntry
	nil,                             // 5: hashicorp.consul.internal.service.CheckType.HeaderEntry
	(*pbcommon.RaftIndex)(nil),      // 6: hashicorp.consul.internal.common.RaftIndex
	(*pbcommon.EnterpriseMeta)(nil), // 7: hashicorp.consul.internal.common.EnterpriseMeta
	(*durationpb.Duration)(nil),     // 8: google.protobuf.Duration
}
var file_private_pbservice_healthcheck_proto_depIdxs = []int32{
	2,  // 0: hashicorp.consul.internal.service.HealthCheck.Definition:type_name -> hashicorp.consul.internal.service.HealthCheckDefinition
	6,  // 1: hashicorp.consul.internal.service.HealthCheck.RaftIndex:type_name -> hashicorp.consul.internal.common.RaftIndex
	7,  // 2: hashicorp.consul.internal.service.HealthCheck.EnterpriseMeta:type_name -> hashicorp.consul.internal.common.EnterpriseMeta
	4,  // 3: hashicorp.consul.internal.service.HealthCheckDefinition.Header:type_name -> hashicorp.consul.internal.service.HealthCheckDefinition.HeaderEntry
	8,  // 4: hashicorp.consul.internal.service.HealthCheckDefinition.Interval:type_name -> google.protobuf.Duration
	8,  // 5: hashicorp.consul.internal.service.HealthCheckDefinition.Timeout:type_name -> google.protobuf.Duration
	8,  // 6: hashicorp.consul.internal.service.HealthCheckDefinition.DeregisterCriticalServiceAfter:type_name -> google.protobuf.Duration
	8,  // 7: hashicorp.consul.internal.service.HealthCheckDefinition.TTL:type_name -> google.protobuf.Duration
	5,  // 8: hashicorp.consul.internal.service.CheckType.Header:type_name -> hashicorp.consul.internal.service.CheckType.HeaderEntry
	8,  // 9: hashicorp.consul.internal.service.CheckType.Interval:type_name -> google.protobuf.Duration
	8,  // 10: hashicorp.consul.internal.service.CheckType.Timeout:type_name -> google.protobuf.Duration
	8,  // 11: hashicorp.consul.internal.service.CheckType.TTL:type_name -> google.protobuf.Duration
	8,  // 12: hashicorp.consul.internal.service.CheckType.DeregisterCriticalServiceAfter:type_name -> google.protobuf.Duration
	1,  // 13: hashicorp.consul.internal.service.HealthCheckDefinition.HeaderEntry.value:type_name -> hashicorp.consul.internal.service.HeaderValue
	1,  // 14: hashicorp.consul.internal.service.CheckType.HeaderEntry.value:type_name -> hashicorp.consul.internal.service.HeaderValue
	15, // [15:15] is the sub-list for method output_type
	15, // [15:15] is the sub-list for method input_type
	15, // [15:15] is the sub-list for extension type_name
	15, // [15:15] is the sub-list for extension extendee
	0,  // [0:15] is the sub-list for field type_name
}

func init() { file_private_pbservice_healthcheck_proto_init() }
func file_private_pbservice_healthcheck_proto_init() {
	if File_private_pbservice_healthcheck_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_private_pbservice_healthcheck_proto_rawDesc), len(file_private_pbservice_healthcheck_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_private_pbservice_healthcheck_proto_goTypes,
		DependencyIndexes: file_private_pbservice_healthcheck_proto_depIdxs,
		MessageInfos:      file_private_pbservice_healthcheck_proto_msgTypes,
	}.Build()
	File_private_pbservice_healthcheck_proto = out.File
	file_private_pbservice_healthcheck_proto_goTypes = nil
	file_private_pbservice_healthcheck_proto_depIdxs = nil
}
