/*
 * Decompiled with CFR 0.152.
 */
package org.cugos.wkg;

import org.cugos.wkg.Dimension;

public final class Coordinate {
    private final double x;
    private final double y;
    private final double z;
    private final double m;

    public Coordinate(double x, double y, double z, double m) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.m = m;
    }

    public Coordinate(double x, double y) {
        this(x, y, Double.NaN, Double.NaN);
    }

    public static Coordinate createEmpty() {
        return new Coordinate(Double.NaN, Double.NaN, Double.NaN, Double.NaN);
    }

    public static Coordinate create2D(double x, double y) {
        return new Coordinate(x, y, Double.NaN, Double.NaN);
    }

    public static Coordinate create3D(double x, double y, double z) {
        return new Coordinate(x, y, z, Double.NaN);
    }

    public static Coordinate create2DM(double x, double y, double m) {
        return new Coordinate(x, y, Double.NaN, m);
    }

    public static Coordinate create3DM(double x, double y, double z, double m) {
        return new Coordinate(x, y, z, m);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getM() {
        return this.m;
    }

    public Dimension getDimension() {
        if (!Double.isNaN(this.m) && !Double.isNaN(this.z)) {
            return Dimension.ThreeMeasured;
        }
        if (!Double.isNaN(this.z)) {
            return Dimension.Three;
        }
        if (!Double.isNaN(this.m)) {
            return Dimension.TwoMeasured;
        }
        return Dimension.Two;
    }

    public boolean isEmpty() {
        return Double.isNaN(this.x) && Double.isNaN(this.y);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Coordinate that = (Coordinate)o;
        if (Double.compare(that.m, this.m) != 0) {
            return false;
        }
        if (Double.compare(that.x, this.x) != 0) {
            return false;
        }
        if (Double.compare(that.y, this.y) != 0) {
            return false;
        }
        return Double.compare(that.z, this.z) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.x);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.z);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        String str = "Coordinate { x = " + this.x + " y = " + this.y;
        if (!Double.isNaN(this.z)) {
            str = str + " z = " + this.z;
        }
        if (!Double.isNaN(this.m)) {
            str = str + " m = " + this.m;
        }
        str = str + " }";
        return str;
    }

    public static class Builder {
        private double x = Double.NaN;
        private double y = Double.NaN;
        private double z = Double.NaN;
        private double m = Double.NaN;

        public Builder setX(double x) {
            this.x = x;
            return this;
        }

        public Builder setY(double y) {
            this.y = y;
            return this;
        }

        public Builder setM(double m) {
            this.m = m;
            return this;
        }

        public Builder setZ(double z) {
            this.z = z;
            return this;
        }

        public Coordinate build() {
            Coordinate coordinate = !Double.isNaN(this.x) && !Double.isNaN(this.y) && !Double.isNaN(this.z) && !Double.isNaN(this.m) ? new Coordinate(this.x, this.y, this.z, this.m) : (!Double.isNaN(this.x) && !Double.isNaN(this.y) && !Double.isNaN(this.z) && Double.isNaN(this.m) ? new Coordinate(this.x, this.y, this.z, Double.NaN) : (!Double.isNaN(this.x) && !Double.isNaN(this.y) && Double.isNaN(this.z) && !Double.isNaN(this.m) ? new Coordinate(this.x, this.y, Double.NaN, this.m) : (!Double.isNaN(this.x) && !Double.isNaN(this.y) && Double.isNaN(this.z) && Double.isNaN(this.m) ? new Coordinate(this.x, this.y, Double.NaN, Double.NaN) : new Coordinate(Double.NaN, Double.NaN, Double.NaN, Double.NaN))));
            this.reset();
            return coordinate;
        }

        private void reset() {
            this.x = Double.NaN;
            this.y = Double.NaN;
            this.z = Double.NaN;
            this.m = Double.NaN;
        }
    }
}

