/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.engine.copilot;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.ai.engine.AIModel;
import org.jkiss.dbeaver.model.ai.engine.AIModelFeature;
import org.jkiss.dbeaver.model.ai.engine.openai.OpenAIModels;
import org.jkiss.dbeaver.model.ai.utils.AIUtils;

public final class CopilotModels {
    public static final Map<String, AIModel> KNOWN_MODELS = AIUtils.modelMap(new AIModel("claude-3.5-sonnet", 200000, Set.of(AIModelFeature.CHAT)), new AIModel("claude-3.7-sonnet", 200000, Set.of(AIModelFeature.CHAT)), new AIModel("claude-3.7-sonnet-thought", 200000, Set.of(AIModelFeature.CHAT)), new AIModel("claude-sonnet-4", 200000, Set.of(AIModelFeature.CHAT)), new AIModel("gemini-2.5", 1000000, Set.of(AIModelFeature.CHAT)), new AIModel("gemini-2.5-pro", 1000000, Set.of(AIModelFeature.CHAT)), new AIModel("gemini-2.0-flash-001", 1000000, Set.of(AIModelFeature.CHAT)));

    private CopilotModels() {
    }

    @NotNull
    public static Optional<AIModel> getModelByName(@Nullable String modelName) {
        Optional<AIModel> model = AIUtils.getModelByName(KNOWN_MODELS, modelName);
        if (model.isPresent()) {
            return Optional.empty();
        }
        return OpenAIModels.getModelByName(modelName);
    }
}

