package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateInstance invokes the ens.CreateInstance API synchronously
func (client *Client) CreateInstance(request *CreateInstanceRequest) (response *CreateInstanceResponse, err error) {
	response = CreateCreateInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// CreateInstanceWithChan invokes the ens.CreateInstance API asynchronously
func (client *Client) CreateInstanceWithChan(request *CreateInstanceRequest) (<-chan *CreateInstanceResponse, <-chan error) {
	responseChan := make(chan *CreateInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateInstanceWithCallback invokes the ens.CreateInstance API asynchronously
func (client *Client) CreateInstanceWithCallback(request *CreateInstanceRequest, callback func(response *CreateInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateInstanceResponse
		var err error
		defer close(result)
		response, err = client.CreateInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateInstanceRequest is the request struct for api CreateInstance
type CreateInstanceRequest struct {
	*requests.RpcRequest
	UniqueSuffix           requests.Boolean `position:"Query" name:"UniqueSuffix"`
	KeyPairName            string           `position:"Query" name:"KeyPairName"`
	Password               string           `position:"Query" name:"Password"`
	HostName               string           `position:"Query" name:"HostName"`
	EnsRegionId            string           `position:"Query" name:"EnsRegionId"`
	AutoRenewPeriod        string           `position:"Query" name:"AutoRenewPeriod"`
	Period                 string           `position:"Query" name:"Period"`
	PublicIpIdentification requests.Boolean `position:"Query" name:"PublicIpIdentification"`
	OwnerId                requests.Integer `position:"Query" name:"OwnerId"`
	VSwitchId              string           `position:"Query" name:"VSwitchId"`
	PrivateIpAddress       string           `position:"Query" name:"PrivateIpAddress"`
	InstanceName           string           `position:"Query" name:"InstanceName"`
	AutoRenew              string           `position:"Query" name:"AutoRenew"`
	InternetChargeType     string           `position:"Query" name:"InternetChargeType"`
	ImageId                string           `position:"Query" name:"ImageId"`
	UserData               string           `position:"Query" name:"UserData"`
	InstanceType           string           `position:"Query" name:"InstanceType"`
	DataDisk1Size          string           `position:"Query" name:"DataDisk.1.Size"`
	Quantity               string           `position:"Query" name:"Quantity"`
	IpType                 string           `position:"Query" name:"IpType"`
	SystemDiskSize         string           `position:"Query" name:"SystemDisk.Size"`
	PaymentType            string           `position:"Query" name:"PaymentType"`
}

// CreateInstanceResponse is the response struct for api CreateInstance
type CreateInstanceResponse struct {
	*responses.BaseResponse
	RequestId   string                      `json:"RequestId" xml:"RequestId"`
	Code        int                         `json:"Code" xml:"Code"`
	InstanceIds InstanceIdsInCreateInstance `json:"InstanceIds" xml:"InstanceIds"`
}

// CreateCreateInstanceRequest creates a request to invoke CreateInstance API
func CreateCreateInstanceRequest() (request *CreateInstanceRequest) {
	request = &CreateInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "CreateInstance", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateInstanceResponse creates a response to parse from CreateInstance response
func CreateCreateInstanceResponse() (response *CreateInstanceResponse) {
	response = &CreateInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
