package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateConfigTemplate invokes the edas.CreateConfigTemplate API synchronously
func (client *Client) CreateConfigTemplate(request *CreateConfigTemplateRequest) (response *CreateConfigTemplateResponse, err error) {
	response = CreateCreateConfigTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// CreateConfigTemplateWithChan invokes the edas.CreateConfigTemplate API asynchronously
func (client *Client) CreateConfigTemplateWithChan(request *CreateConfigTemplateRequest) (<-chan *CreateConfigTemplateResponse, <-chan error) {
	responseChan := make(chan *CreateConfigTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateConfigTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateConfigTemplateWithCallback invokes the edas.CreateConfigTemplate API asynchronously
func (client *Client) CreateConfigTemplateWithCallback(request *CreateConfigTemplateRequest, callback func(response *CreateConfigTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateConfigTemplateResponse
		var err error
		defer close(result)
		response, err = client.CreateConfigTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateConfigTemplateRequest is the request struct for api CreateConfigTemplate
type CreateConfigTemplateRequest struct {
	*requests.RoaRequest
	Name        string `position:"Body" name:"Name"`
	Format      string `position:"Body" name:"Format"`
	Description string `position:"Body" name:"Description"`
	Content     string `position:"Body" name:"Content"`
}

// CreateConfigTemplateResponse is the response struct for api CreateConfigTemplate
type CreateConfigTemplateResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCreateConfigTemplateRequest creates a request to invoke CreateConfigTemplate API
func CreateCreateConfigTemplateRequest() (request *CreateConfigTemplateRequest) {
	request = &CreateConfigTemplateRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "CreateConfigTemplate", "/pop/v5/config_template", "Edas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateConfigTemplateResponse creates a response to parse from CreateConfigTemplate response
func CreateCreateConfigTemplateResponse() (response *CreateConfigTemplateResponse) {
	response = &CreateConfigTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
