package eais

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateEaiAll invokes the eais.CreateEaiAll API synchronously
func (client *Client) CreateEaiAll(request *CreateEaiAllRequest) (response *CreateEaiAllResponse, err error) {
	response = CreateCreateEaiAllResponse()
	err = client.DoAction(request, response)
	return
}

// CreateEaiAllWithChan invokes the eais.CreateEaiAll API asynchronously
func (client *Client) CreateEaiAllWithChan(request *CreateEaiAllRequest) (<-chan *CreateEaiAllResponse, <-chan error) {
	responseChan := make(chan *CreateEaiAllResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateEaiAll(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateEaiAllWithCallback invokes the eais.CreateEaiAll API asynchronously
func (client *Client) CreateEaiAllWithCallback(request *CreateEaiAllRequest, callback func(response *CreateEaiAllResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateEaiAllResponse
		var err error
		defer close(result)
		response, err = client.CreateEaiAll(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateEaiAllRequest is the request struct for api CreateEaiAll
type CreateEaiAllRequest struct {
	*requests.RpcRequest
	ClientImageId                 string           `position:"Query" name:"ClientImageId"`
	ClientSystemDiskCategory      string           `position:"Query" name:"ClientSystemDiskCategory"`
	ClientInternetMaxBandwidthOut requests.Integer `position:"Query" name:"ClientInternetMaxBandwidthOut"`
	ClientToken                   string           `position:"Query" name:"ClientToken"`
	ClientInstanceName            string           `position:"Query" name:"ClientInstanceName"`
	ClientInternetMaxBandwidthIn  requests.Integer `position:"Query" name:"ClientInternetMaxBandwidthIn"`
	ClientSystemDiskSize          requests.Integer `position:"Query" name:"ClientSystemDiskSize"`
	ClientVSwitchId               string           `position:"Query" name:"ClientVSwitchId"`
	ClientPassword                string           `position:"Query" name:"ClientPassword"`
	ClientInstanceType            string           `position:"Query" name:"ClientInstanceType"`
	ClientSecurityGroupId         string           `position:"Query" name:"ClientSecurityGroupId"`
	EaiInstanceType               string           `position:"Query" name:"EaiInstanceType"`
	ClientZoneId                  string           `position:"Query" name:"ClientZoneId"`
	InstanceName                  string           `position:"Query" name:"InstanceName"`
}

// CreateEaiAllResponse is the response struct for api CreateEaiAll
type CreateEaiAllResponse struct {
	*responses.BaseResponse
	RequestId                    string `json:"RequestId" xml:"RequestId"`
	ElasticAcceleratedInstanceId string `json:"ElasticAcceleratedInstanceId" xml:"ElasticAcceleratedInstanceId"`
	ClientInstanceId             string `json:"ClientInstanceId" xml:"ClientInstanceId"`
}

// CreateCreateEaiAllRequest creates a request to invoke CreateEaiAll API
func CreateCreateEaiAllRequest() (request *CreateEaiAllRequest) {
	request = &CreateEaiAllRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eais", "2019-06-24", "CreateEaiAll", "eais", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateEaiAllResponse creates a response to parse from CreateEaiAll response
func CreateCreateEaiAllResponse() (response *CreateEaiAllResponse) {
	response = &CreateEaiAllResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
