package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PublishRoutineCodeRevision invokes the dcdn.PublishRoutineCodeRevision API synchronously
func (client *Client) PublishRoutineCodeRevision(request *PublishRoutineCodeRevisionRequest) (response *PublishRoutineCodeRevisionResponse, err error) {
	response = CreatePublishRoutineCodeRevisionResponse()
	err = client.DoAction(request, response)
	return
}

// PublishRoutineCodeRevisionWithChan invokes the dcdn.PublishRoutineCodeRevision API asynchronously
func (client *Client) PublishRoutineCodeRevisionWithChan(request *PublishRoutineCodeRevisionRequest) (<-chan *PublishRoutineCodeRevisionResponse, <-chan error) {
	responseChan := make(chan *PublishRoutineCodeRevisionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PublishRoutineCodeRevision(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PublishRoutineCodeRevisionWithCallback invokes the dcdn.PublishRoutineCodeRevision API asynchronously
func (client *Client) PublishRoutineCodeRevisionWithCallback(request *PublishRoutineCodeRevisionRequest, callback func(response *PublishRoutineCodeRevisionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PublishRoutineCodeRevisionResponse
		var err error
		defer close(result)
		response, err = client.PublishRoutineCodeRevision(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PublishRoutineCodeRevisionRequest is the request struct for api PublishRoutineCodeRevision
type PublishRoutineCodeRevisionRequest struct {
	*requests.RpcRequest
	SelectCodeRevision string           `position:"Body" name:"SelectCodeRevision"`
	Envs               string           `position:"Body" name:"Envs"`
	OwnerId            requests.Integer `position:"Query" name:"OwnerId"`
	Name               string           `position:"Body" name:"Name"`
}

// PublishRoutineCodeRevisionResponse is the response struct for api PublishRoutineCodeRevision
type PublishRoutineCodeRevisionResponse struct {
	*responses.BaseResponse
	RequestId string                 `json:"RequestId" xml:"RequestId"`
	Content   map[string]interface{} `json:"Content" xml:"Content"`
}

// CreatePublishRoutineCodeRevisionRequest creates a request to invoke PublishRoutineCodeRevision API
func CreatePublishRoutineCodeRevisionRequest() (request *PublishRoutineCodeRevisionRequest) {
	request = &PublishRoutineCodeRevisionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "PublishRoutineCodeRevision", "", "")
	request.Method = requests.POST
	return
}

// CreatePublishRoutineCodeRevisionResponse creates a response to parse from PublishRoutineCodeRevision response
func CreatePublishRoutineCodeRevisionResponse() (response *PublishRoutineCodeRevisionResponse) {
	response = &PublishRoutineCodeRevisionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
