package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateTable invokes the dataworks_public.CreateTable API synchronously
func (client *Client) CreateTable(request *CreateTableRequest) (response *CreateTableResponse, err error) {
	response = CreateCreateTableResponse()
	err = client.DoAction(request, response)
	return
}

// CreateTableWithChan invokes the dataworks_public.CreateTable API asynchronously
func (client *Client) CreateTableWithChan(request *CreateTableRequest) (<-chan *CreateTableResponse, <-chan error) {
	responseChan := make(chan *CreateTableResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateTable(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateTableWithCallback invokes the dataworks_public.CreateTable API asynchronously
func (client *Client) CreateTableWithCallback(request *CreateTableRequest, callback func(response *CreateTableResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateTableResponse
		var err error
		defer close(result)
		response, err = client.CreateTable(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateTableRequest is the request struct for api CreateTable
type CreateTableRequest struct {
	*requests.RpcRequest
	ClientToken       string                `position:"Query" name:"ClientToken"`
	Columns           *[]CreateTableColumns `position:"Body" name:"Columns"  type:"Repeated"`
	LifeCycle         requests.Integer      `position:"Query" name:"LifeCycle"`
	Themes            *[]CreateTableThemes  `position:"Body" name:"Themes"  type:"Repeated"`
	LogicalLevelId    requests.Integer      `position:"Query" name:"LogicalLevelId"`
	Endpoint          string                `position:"Body" name:"Endpoint"`
	EnvType           requests.Integer      `position:"Body" name:"EnvType"`
	HasPart           requests.Integer      `position:"Query" name:"HasPart"`
	TableName         string                `position:"Query" name:"TableName"`
	AppGuid           string                `position:"Query" name:"AppGuid"`
	ProjectId         requests.Integer      `position:"Query" name:"ProjectId"`
	CategoryId        requests.Integer      `position:"Query" name:"CategoryId"`
	Visibility        requests.Integer      `position:"Query" name:"Visibility"`
	PhysicsLevelId    requests.Integer      `position:"Query" name:"PhysicsLevelId"`
	OwnerId           string                `position:"Query" name:"OwnerId"`
	IsView            requests.Integer      `position:"Query" name:"IsView"`
	ExternalTableType string                `position:"Query" name:"ExternalTableType"`
	Location          string                `position:"Query" name:"Location"`
	Comment           string                `position:"Query" name:"Comment"`
}

// CreateTableColumns is a repeated param struct in CreateTableRequest
type CreateTableColumns struct {
	SeqNumber      string `name:"SeqNumber"`
	IsPartitionCol string `name:"IsPartitionCol"`
	ColumnNameCn   string `name:"ColumnNameCn"`
	Length         string `name:"Length"`
	Comment        string `name:"Comment"`
	ColumnName     string `name:"ColumnName"`
	ColumnType     string `name:"ColumnType"`
}

// CreateTableThemes is a repeated param struct in CreateTableRequest
type CreateTableThemes struct {
	ThemeLevel string `name:"ThemeLevel"`
	ThemeId    string `name:"ThemeId"`
}

// CreateTableResponse is the response struct for api CreateTable
type CreateTableResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	TaskInfo  TaskInfo `json:"TaskInfo" xml:"TaskInfo"`
}

// CreateCreateTableRequest creates a request to invoke CreateTable API
func CreateCreateTableRequest() (request *CreateTableRequest) {
	request = &CreateTableRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "CreateTable", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateTableResponse creates a response to parse from CreateTable response
func CreateCreateTableResponse() (response *CreateTableResponse) {
	response = &CreateTableResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
