package cr_ee

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetInstanceEndpoint invokes the cr.GetInstanceEndpoint API synchronously
// api document: https://help.aliyun.com/api/cr/getinstanceendpoint.html
func (client *Client) GetInstanceEndpoint(request *GetInstanceEndpointRequest) (response *GetInstanceEndpointResponse, err error) {
	response = CreateGetInstanceEndpointResponse()
	err = client.DoAction(request, response)
	return
}

// GetInstanceEndpointWithChan invokes the cr.GetInstanceEndpoint API asynchronously
// api document: https://help.aliyun.com/api/cr/getinstanceendpoint.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetInstanceEndpointWithChan(request *GetInstanceEndpointRequest) (<-chan *GetInstanceEndpointResponse, <-chan error) {
	responseChan := make(chan *GetInstanceEndpointResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetInstanceEndpoint(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetInstanceEndpointWithCallback invokes the cr.GetInstanceEndpoint API asynchronously
// api document: https://help.aliyun.com/api/cr/getinstanceendpoint.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetInstanceEndpointWithCallback(request *GetInstanceEndpointRequest, callback func(response *GetInstanceEndpointResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetInstanceEndpointResponse
		var err error
		defer close(result)
		response, err = client.GetInstanceEndpoint(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetInstanceEndpointRequest is the request struct for api GetInstanceEndpoint
type GetInstanceEndpointRequest struct {
	*requests.RpcRequest
	InstanceId   string `position:"Query" name:"InstanceId"`
	EndpointType string `position:"Query" name:"EndpointType"`
	ModuleName   string `position:"Query" name:"ModuleName"`
}

// GetInstanceEndpointResponse is the response struct for api GetInstanceEndpoint
type GetInstanceEndpointResponse struct {
	*responses.BaseResponse
	GetInstanceEndpointIsSuccess bool             `json:"IsSuccess" xml:"IsSuccess"`
	Code                         string           `json:"Code" xml:"Code"`
	RequestId                    string           `json:"RequestId" xml:"RequestId"`
	Enable                       bool             `json:"Enable" xml:"Enable"`
	AclEnable                    bool             `json:"AclEnable" xml:"AclEnable"`
	Status                       string           `json:"Status" xml:"Status"`
	Domains                      []Endpoints      `json:"Domains" xml:"Domains"`
	AclEntries                   []AclEntriesItem `json:"AclEntries" xml:"AclEntries"`
}

// CreateGetInstanceEndpointRequest creates a request to invoke GetInstanceEndpoint API
func CreateGetInstanceEndpointRequest() (request *GetInstanceEndpointRequest) {
	request = &GetInstanceEndpointRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cr", "2018-12-01", "GetInstanceEndpoint", "acr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetInstanceEndpointResponse creates a response to parse from GetInstanceEndpoint response
func CreateGetInstanceEndpointResponse() (response *GetInstanceEndpointResponse) {
	response = &GetInstanceEndpointResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
