package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeactiveAggregateConfigRules invokes the config.DeactiveAggregateConfigRules API synchronously
func (client *Client) DeactiveAggregateConfigRules(request *DeactiveAggregateConfigRulesRequest) (response *DeactiveAggregateConfigRulesResponse, err error) {
	response = CreateDeactiveAggregateConfigRulesResponse()
	err = client.DoAction(request, response)
	return
}

// DeactiveAggregateConfigRulesWithChan invokes the config.DeactiveAggregateConfigRules API asynchronously
func (client *Client) DeactiveAggregateConfigRulesWithChan(request *DeactiveAggregateConfigRulesRequest) (<-chan *DeactiveAggregateConfigRulesResponse, <-chan error) {
	responseChan := make(chan *DeactiveAggregateConfigRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeactiveAggregateConfigRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeactiveAggregateConfigRulesWithCallback invokes the config.DeactiveAggregateConfigRules API asynchronously
func (client *Client) DeactiveAggregateConfigRulesWithCallback(request *DeactiveAggregateConfigRulesRequest, callback func(response *DeactiveAggregateConfigRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeactiveAggregateConfigRulesResponse
		var err error
		defer close(result)
		response, err = client.DeactiveAggregateConfigRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeactiveAggregateConfigRulesRequest is the request struct for api DeactiveAggregateConfigRules
type DeactiveAggregateConfigRulesRequest struct {
	*requests.RpcRequest
	ConfigRuleIds string `position:"Query" name:"ConfigRuleIds"`
	AggregatorId  string `position:"Query" name:"AggregatorId"`
}

// DeactiveAggregateConfigRulesResponse is the response struct for api DeactiveAggregateConfigRules
type DeactiveAggregateConfigRulesResponse struct {
	*responses.BaseResponse
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	OperateRuleResult OperateRuleResult `json:"OperateRuleResult" xml:"OperateRuleResult"`
}

// CreateDeactiveAggregateConfigRulesRequest creates a request to invoke DeactiveAggregateConfigRules API
func CreateDeactiveAggregateConfigRulesRequest() (request *DeactiveAggregateConfigRulesRequest) {
	request = &DeactiveAggregateConfigRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "DeactiveAggregateConfigRules", "", "")
	request.Method = requests.POST
	return
}

// CreateDeactiveAggregateConfigRulesResponse creates a response to parse from DeactiveAggregateConfigRules response
func CreateDeactiveAggregateConfigRulesResponse() (response *DeactiveAggregateConfigRulesResponse) {
	response = &DeactiveAggregateConfigRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
