package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitIntentionNote invokes the companyreg.SubmitIntentionNote API synchronously
func (client *Client) SubmitIntentionNote(request *SubmitIntentionNoteRequest) (response *SubmitIntentionNoteResponse, err error) {
	response = CreateSubmitIntentionNoteResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitIntentionNoteWithChan invokes the companyreg.SubmitIntentionNote API asynchronously
func (client *Client) SubmitIntentionNoteWithChan(request *SubmitIntentionNoteRequest) (<-chan *SubmitIntentionNoteResponse, <-chan error) {
	responseChan := make(chan *SubmitIntentionNoteResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitIntentionNote(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitIntentionNoteWithCallback invokes the companyreg.SubmitIntentionNote API asynchronously
func (client *Client) SubmitIntentionNoteWithCallback(request *SubmitIntentionNoteRequest, callback func(response *SubmitIntentionNoteResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitIntentionNoteResponse
		var err error
		defer close(result)
		response, err = client.SubmitIntentionNote(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitIntentionNoteRequest is the request struct for api SubmitIntentionNote
type SubmitIntentionNoteRequest struct {
	*requests.RpcRequest
	Note           string `position:"Query" name:"Note"`
	IntentionBizId string `position:"Query" name:"IntentionBizId"`
}

// SubmitIntentionNoteResponse is the response struct for api SubmitIntentionNote
type SubmitIntentionNoteResponse struct {
	*responses.BaseResponse
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateSubmitIntentionNoteRequest creates a request to invoke SubmitIntentionNote API
func CreateSubmitIntentionNoteRequest() (request *SubmitIntentionNoteRequest) {
	request = &SubmitIntentionNoteRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-03-06", "SubmitIntentionNote", "", "")
	request.Method = requests.POST
	return
}

// CreateSubmitIntentionNoteResponse creates a response to parse from SubmitIntentionNote response
func CreateSubmitIntentionNoteResponse() (response *SubmitIntentionNoteResponse) {
	response = &SubmitIntentionNoteResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
