package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PushSipAgentGroup invokes the cloudcallcenter.PushSipAgentGroup API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/pushsipagentgroup.html
func (client *Client) PushSipAgentGroup(request *PushSipAgentGroupRequest) (response *PushSipAgentGroupResponse, err error) {
	response = CreatePushSipAgentGroupResponse()
	err = client.DoAction(request, response)
	return
}

// PushSipAgentGroupWithChan invokes the cloudcallcenter.PushSipAgentGroup API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/pushsipagentgroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PushSipAgentGroupWithChan(request *PushSipAgentGroupRequest) (<-chan *PushSipAgentGroupResponse, <-chan error) {
	responseChan := make(chan *PushSipAgentGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PushSipAgentGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PushSipAgentGroupWithCallback invokes the cloudcallcenter.PushSipAgentGroup API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/pushsipagentgroup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PushSipAgentGroupWithCallback(request *PushSipAgentGroupRequest, callback func(response *PushSipAgentGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PushSipAgentGroupResponse
		var err error
		defer close(result)
		response, err = client.PushSipAgentGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PushSipAgentGroupRequest is the request struct for api PushSipAgentGroup
type PushSipAgentGroupRequest struct {
	*requests.RpcRequest
	Provider string `position:"Query" name:"Provider"`
}

// PushSipAgentGroupResponse is the response struct for api PushSipAgentGroup
type PushSipAgentGroupResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreatePushSipAgentGroupRequest creates a request to invoke PushSipAgentGroup API
func CreatePushSipAgentGroupRequest() (request *PushSipAgentGroupRequest) {
	request = &PushSipAgentGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "PushSipAgentGroup", "", "")
	request.Method = requests.POST
	return
}

// CreatePushSipAgentGroupResponse creates a response to parse from PushSipAgentGroup response
func CreatePushSipAgentGroupResponse() (response *PushSipAgentGroupResponse) {
	response = &PushSipAgentGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
