package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetNotificationConfig invokes the cloudcallcenter.GetNotificationConfig API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getnotificationconfig.html
func (client *Client) GetNotificationConfig(request *GetNotificationConfigRequest) (response *GetNotificationConfigResponse, err error) {
	response = CreateGetNotificationConfigResponse()
	err = client.DoAction(request, response)
	return
}

// GetNotificationConfigWithChan invokes the cloudcallcenter.GetNotificationConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getnotificationconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetNotificationConfigWithChan(request *GetNotificationConfigRequest) (<-chan *GetNotificationConfigResponse, <-chan error) {
	responseChan := make(chan *GetNotificationConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetNotificationConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetNotificationConfigWithCallback invokes the cloudcallcenter.GetNotificationConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getnotificationconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetNotificationConfigWithCallback(request *GetNotificationConfigRequest, callback func(response *GetNotificationConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetNotificationConfigResponse
		var err error
		defer close(result)
		response, err = client.GetNotificationConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetNotificationConfigRequest is the request struct for api GetNotificationConfig
type GetNotificationConfigRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
}

// GetNotificationConfigResponse is the response struct for api GetNotificationConfig
type GetNotificationConfigResponse struct {
	*responses.BaseResponse
	RequestId      string                               `json:"RequestId" xml:"RequestId"`
	Success        bool                                 `json:"Success" xml:"Success"`
	Code           string                               `json:"Code" xml:"Code"`
	Message        string                               `json:"Message" xml:"Message"`
	HttpStatusCode int                                  `json:"HttpStatusCode" xml:"HttpStatusCode"`
	ProducerId     string                               `json:"ProducerId" xml:"ProducerId"`
	AccessPoint    string                               `json:"AccessPoint" xml:"AccessPoint"`
	Topic          string                               `json:"Topic" xml:"Topic"`
	Subscriptions  SubscriptionsInGetNotificationConfig `json:"Subscriptions" xml:"Subscriptions"`
}

// CreateGetNotificationConfigRequest creates a request to invoke GetNotificationConfig API
func CreateGetNotificationConfigRequest() (request *GetNotificationConfigRequest) {
	request = &GetNotificationConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "GetNotificationConfig", "", "")
	request.Method = requests.POST
	return
}

// CreateGetNotificationConfigResponse creates a response to parse from GetNotificationConfig response
func CreateGetNotificationConfigResponse() (response *GetNotificationConfigResponse) {
	response = &GetNotificationConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
