package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetJobTemplateDownloadParams invokes the cloudcallcenter.GetJobTemplateDownloadParams API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getjobtemplatedownloadparams.html
func (client *Client) GetJobTemplateDownloadParams(request *GetJobTemplateDownloadParamsRequest) (response *GetJobTemplateDownloadParamsResponse, err error) {
	response = CreateGetJobTemplateDownloadParamsResponse()
	err = client.DoAction(request, response)
	return
}

// GetJobTemplateDownloadParamsWithChan invokes the cloudcallcenter.GetJobTemplateDownloadParams API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getjobtemplatedownloadparams.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetJobTemplateDownloadParamsWithChan(request *GetJobTemplateDownloadParamsRequest) (<-chan *GetJobTemplateDownloadParamsResponse, <-chan error) {
	responseChan := make(chan *GetJobTemplateDownloadParamsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetJobTemplateDownloadParams(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetJobTemplateDownloadParamsWithCallback invokes the cloudcallcenter.GetJobTemplateDownloadParams API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getjobtemplatedownloadparams.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetJobTemplateDownloadParamsWithCallback(request *GetJobTemplateDownloadParamsRequest, callback func(response *GetJobTemplateDownloadParamsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetJobTemplateDownloadParamsResponse
		var err error
		defer close(result)
		response, err = client.GetJobTemplateDownloadParams(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetJobTemplateDownloadParamsRequest is the request struct for api GetJobTemplateDownloadParams
type GetJobTemplateDownloadParamsRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	ScenarioId string `position:"Query" name:"ScenarioId"`
}

// GetJobTemplateDownloadParamsResponse is the response struct for api GetJobTemplateDownloadParams
type GetJobTemplateDownloadParamsResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	Success        bool           `json:"Success" xml:"Success"`
	Code           string         `json:"Code" xml:"Code"`
	Message        string         `json:"Message" xml:"Message"`
	HttpStatusCode int            `json:"HttpStatusCode" xml:"HttpStatusCode"`
	DownloadParams DownloadParams `json:"DownloadParams" xml:"DownloadParams"`
}

// CreateGetJobTemplateDownloadParamsRequest creates a request to invoke GetJobTemplateDownloadParams API
func CreateGetJobTemplateDownloadParamsRequest() (request *GetJobTemplateDownloadParamsRequest) {
	request = &GetJobTemplateDownloadParamsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "GetJobTemplateDownloadParams", "", "")
	request.Method = requests.POST
	return
}

// CreateGetJobTemplateDownloadParamsResponse creates a response to parse from GetJobTemplateDownloadParams response
func CreateGetJobTemplateDownloadParamsResponse() (response *GetJobTemplateDownloadParamsResponse) {
	response = &GetJobTemplateDownloadParamsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
