package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DialogueVn invokes the cloudcallcenter.DialogueVn API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/dialoguevn.html
func (client *Client) DialogueVn(request *DialogueVnRequest) (response *DialogueVnResponse, err error) {
	response = CreateDialogueVnResponse()
	err = client.DoAction(request, response)
	return
}

// DialogueVnWithChan invokes the cloudcallcenter.DialogueVn API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/dialoguevn.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DialogueVnWithChan(request *DialogueVnRequest) (<-chan *DialogueVnResponse, <-chan error) {
	responseChan := make(chan *DialogueVnResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DialogueVn(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DialogueVnWithCallback invokes the cloudcallcenter.DialogueVn API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/dialoguevn.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DialogueVnWithCallback(request *DialogueVnRequest, callback func(response *DialogueVnResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DialogueVnResponse
		var err error
		defer close(result)
		response, err = client.DialogueVn(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DialogueVnRequest is the request struct for api DialogueVn
type DialogueVnRequest struct {
	*requests.RpcRequest
	ConversationId    string `position:"Query" name:"ConversationId"`
	CallingNumber     string `position:"Query" name:"CallingNumber"`
	InstanceId        string `position:"Query" name:"InstanceId"`
	CalledNumber      string `position:"Query" name:"CalledNumber"`
	AdditionalContext string `position:"Query" name:"AdditionalContext"`
	Utterance         string `position:"Query" name:"Utterance"`
}

// DialogueVnResponse is the response struct for api DialogueVn
type DialogueVnResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	TextResponse  string `json:"TextResponse" xml:"TextResponse"`
	Interruptible bool   `json:"Interruptible" xml:"Interruptible"`
	Action        string `json:"Action" xml:"Action"`
	ActionParams  string `json:"ActionParams" xml:"ActionParams"`
}

// CreateDialogueVnRequest creates a request to invoke DialogueVn API
func CreateDialogueVnRequest() (request *DialogueVnRequest) {
	request = &DialogueVnRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "DialogueVn", "", "")
	request.Method = requests.GET
	return
}

// CreateDialogueVnResponse creates a response to parse from DialogueVn response
func CreateDialogueVnResponse() (response *DialogueVnResponse) {
	response = &DialogueVnResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
