package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetVpcAccess invokes the cloudapi.SetVpcAccess API synchronously
// api document: https://help.aliyun.com/api/cloudapi/setvpcaccess.html
func (client *Client) SetVpcAccess(request *SetVpcAccessRequest) (response *SetVpcAccessResponse, err error) {
	response = CreateSetVpcAccessResponse()
	err = client.DoAction(request, response)
	return
}

// SetVpcAccessWithChan invokes the cloudapi.SetVpcAccess API asynchronously
// api document: https://help.aliyun.com/api/cloudapi/setvpcaccess.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SetVpcAccessWithChan(request *SetVpcAccessRequest) (<-chan *SetVpcAccessResponse, <-chan error) {
	responseChan := make(chan *SetVpcAccessResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetVpcAccess(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetVpcAccessWithCallback invokes the cloudapi.SetVpcAccess API asynchronously
// api document: https://help.aliyun.com/api/cloudapi/setvpcaccess.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SetVpcAccessWithCallback(request *SetVpcAccessRequest, callback func(response *SetVpcAccessResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetVpcAccessResponse
		var err error
		defer close(result)
		response, err = client.SetVpcAccess(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetVpcAccessRequest is the request struct for api SetVpcAccess
type SetVpcAccessRequest struct {
	*requests.RpcRequest
	InstanceId    string           `position:"Query" name:"InstanceId"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	Port          requests.Integer `position:"Query" name:"Port"`
	VpcId         string           `position:"Query" name:"VpcId"`
	Name          string           `position:"Query" name:"Name"`
}

// SetVpcAccessResponse is the response struct for api SetVpcAccess
type SetVpcAccessResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetVpcAccessRequest creates a request to invoke SetVpcAccess API
func CreateSetVpcAccessRequest() (request *SetVpcAccessRequest) {
	request = &SetVpcAccessRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "SetVpcAccess", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetVpcAccessResponse creates a response to parse from SetVpcAccess response
func CreateSetVpcAccessResponse() (response *SetVpcAccessResponse) {
	response = &SetVpcAccessResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
