package cdrs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UnbindDevice invokes the cdrs.UnbindDevice API synchronously
func (client *Client) UnbindDevice(request *UnbindDeviceRequest) (response *UnbindDeviceResponse, err error) {
	response = CreateUnbindDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// UnbindDeviceWithChan invokes the cdrs.UnbindDevice API asynchronously
func (client *Client) UnbindDeviceWithChan(request *UnbindDeviceRequest) (<-chan *UnbindDeviceResponse, <-chan error) {
	responseChan := make(chan *UnbindDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UnbindDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UnbindDeviceWithCallback invokes the cdrs.UnbindDevice API asynchronously
func (client *Client) UnbindDeviceWithCallback(request *UnbindDeviceRequest, callback func(response *UnbindDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UnbindDeviceResponse
		var err error
		defer close(result)
		response, err = client.UnbindDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UnbindDeviceRequest is the request struct for api UnbindDevice
type UnbindDeviceRequest struct {
	*requests.RpcRequest
	DeviceIds string `position:"Body" name:"DeviceIds"`
	CorpId    string `position:"Body" name:"CorpId"`
	AppName   string `position:"Body" name:"AppName"`
	NameSpace string `position:"Body" name:"NameSpace"`
}

// UnbindDeviceResponse is the response struct for api UnbindDevice
type UnbindDeviceResponse struct {
	*responses.BaseResponse
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Code      string  `json:"Code" xml:"Code"`
	Message   string  `json:"Message" xml:"Message"`
	Data      []Datas `json:"Data" xml:"Data"`
}

// CreateUnbindDeviceRequest creates a request to invoke UnbindDevice API
func CreateUnbindDeviceRequest() (request *UnbindDeviceRequest) {
	request = &UnbindDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CDRS", "2020-11-01", "UnbindDevice", "", "")
	request.Method = requests.POST
	return
}

// CreateUnbindDeviceResponse creates a response to parse from UnbindDevice response
func CreateUnbindDeviceResponse() (response *UnbindDeviceResponse) {
	response = &UnbindDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
