package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListHistoricalSkillGroupReport invokes the ccc.ListHistoricalSkillGroupReport API synchronously
func (client *Client) ListHistoricalSkillGroupReport(request *ListHistoricalSkillGroupReportRequest) (response *ListHistoricalSkillGroupReportResponse, err error) {
	response = CreateListHistoricalSkillGroupReportResponse()
	err = client.DoAction(request, response)
	return
}

// ListHistoricalSkillGroupReportWithChan invokes the ccc.ListHistoricalSkillGroupReport API asynchronously
func (client *Client) ListHistoricalSkillGroupReportWithChan(request *ListHistoricalSkillGroupReportRequest) (<-chan *ListHistoricalSkillGroupReportResponse, <-chan error) {
	responseChan := make(chan *ListHistoricalSkillGroupReportResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListHistoricalSkillGroupReport(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListHistoricalSkillGroupReportWithCallback invokes the ccc.ListHistoricalSkillGroupReport API asynchronously
func (client *Client) ListHistoricalSkillGroupReportWithCallback(request *ListHistoricalSkillGroupReportRequest, callback func(response *ListHistoricalSkillGroupReportResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListHistoricalSkillGroupReportResponse
		var err error
		defer close(result)
		response, err = client.ListHistoricalSkillGroupReport(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListHistoricalSkillGroupReportRequest is the request struct for api ListHistoricalSkillGroupReport
type ListHistoricalSkillGroupReportRequest struct {
	*requests.RpcRequest
	EndTime          requests.Integer `position:"Query" name:"EndTime"`
	StartTime        requests.Integer `position:"Query" name:"StartTime"`
	PageNumber       requests.Integer `position:"Query" name:"PageNumber"`
	SkillGroupIdList string           `position:"Body" name:"SkillGroupIdList"`
	InstanceId       string           `position:"Query" name:"InstanceId"`
	PageSize         requests.Integer `position:"Query" name:"PageSize"`
}

// ListHistoricalSkillGroupReportResponse is the response struct for api ListHistoricalSkillGroupReport
type ListHistoricalSkillGroupReportResponse struct {
	*responses.BaseResponse
	Code           string                               `json:"Code" xml:"Code"`
	HttpStatusCode int                                  `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string                               `json:"Message" xml:"Message"`
	RequestId      string                               `json:"RequestId" xml:"RequestId"`
	Data           DataInListHistoricalSkillGroupReport `json:"Data" xml:"Data"`
}

// CreateListHistoricalSkillGroupReportRequest creates a request to invoke ListHistoricalSkillGroupReport API
func CreateListHistoricalSkillGroupReportRequest() (request *ListHistoricalSkillGroupReportRequest) {
	request = &ListHistoricalSkillGroupReportRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "ListHistoricalSkillGroupReport", "", "")
	request.Method = requests.POST
	return
}

// CreateListHistoricalSkillGroupReportResponse creates a response to parse from ListHistoricalSkillGroupReport response
func CreateListHistoricalSkillGroupReportResponse() (response *ListHistoricalSkillGroupReportResponse) {
	response = &ListHistoricalSkillGroupReportResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
