package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DownloadFabricOrganizationSDK invokes the baas.DownloadFabricOrganizationSDK API synchronously
// api document: https://help.aliyun.com/api/baas/downloadfabricorganizationsdk.html
func (client *Client) DownloadFabricOrganizationSDK(request *DownloadFabricOrganizationSDKRequest) (response *DownloadFabricOrganizationSDKResponse, err error) {
	response = CreateDownloadFabricOrganizationSDKResponse()
	err = client.DoAction(request, response)
	return
}

// DownloadFabricOrganizationSDKWithChan invokes the baas.DownloadFabricOrganizationSDK API asynchronously
// api document: https://help.aliyun.com/api/baas/downloadfabricorganizationsdk.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DownloadFabricOrganizationSDKWithChan(request *DownloadFabricOrganizationSDKRequest) (<-chan *DownloadFabricOrganizationSDKResponse, <-chan error) {
	responseChan := make(chan *DownloadFabricOrganizationSDKResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DownloadFabricOrganizationSDK(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DownloadFabricOrganizationSDKWithCallback invokes the baas.DownloadFabricOrganizationSDK API asynchronously
// api document: https://help.aliyun.com/api/baas/downloadfabricorganizationsdk.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DownloadFabricOrganizationSDKWithCallback(request *DownloadFabricOrganizationSDKRequest, callback func(response *DownloadFabricOrganizationSDKResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DownloadFabricOrganizationSDKResponse
		var err error
		defer close(result)
		response, err = client.DownloadFabricOrganizationSDK(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DownloadFabricOrganizationSDKRequest is the request struct for api DownloadFabricOrganizationSDK
type DownloadFabricOrganizationSDKRequest struct {
	*requests.RpcRequest
	OrganizationId string `position:"Query" name:"OrganizationId"`
	Location       string `position:"Body" name:"Location"`
	Username       string `position:"Query" name:"Username"`
}

// DownloadFabricOrganizationSDKResponse is the response struct for api DownloadFabricOrganizationSDK
type DownloadFabricOrganizationSDKResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"RequestId" xml:"RequestId"`
	Success   bool         `json:"Success" xml:"Success"`
	ErrorCode int          `json:"ErrorCode" xml:"ErrorCode"`
	Result    []ResultItem `json:"Result" xml:"Result"`
}

// CreateDownloadFabricOrganizationSDKRequest creates a request to invoke DownloadFabricOrganizationSDK API
func CreateDownloadFabricOrganizationSDKRequest() (request *DownloadFabricOrganizationSDKRequest) {
	request = &DownloadFabricOrganizationSDKRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-12-21", "DownloadFabricOrganizationSDK", "baas", "openAPI")
	return
}

// CreateDownloadFabricOrganizationSDKResponse creates a response to parse from DownloadFabricOrganizationSDK response
func CreateDownloadFabricOrganizationSDKResponse() (response *DownloadFabricOrganizationSDKResponse) {
	response = &DownloadFabricOrganizationSDKResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
